<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Organismo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index()
    {
        $users = User::with('organismo')->paginate(15);
        return view('admin.users.index', compact('users'));
    }

    public function create()
    {
        $organismos = Organismo::all();
        return view('admin.users.create', compact('organismos'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',
            'telefono' => 'nullable|string|max:30',
            'role' => 'required|in:admin,moderador,lectura',
            'organismo_id' => 'nullable|exists:organismos,id',
            'password' => 'required|confirmed|min:6',
        ]);
        $validated['password'] = Hash::make($validated['password']);
        $validated['name'] = $validated['first_name'] . ' ' . $validated['last_name'];
        User::create($validated);
        return redirect()->route('admin.users.index')->with('success', 'Usuario creado correctamente');
    }

    public function edit($id)
    {
        $user = \App\Models\User::findOrFail($id);
        $organismos = \App\Models\Organismo::all();
        return view('admin.users.edit', compact('user', 'organismos'));
    }

    public function update(Request $request, $id)
    {
        $user = \App\Models\User::findOrFail($id);
        $validated = $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users,email,' . $user->id,
            'telefono' => 'nullable|string|max:30',
            'role' => 'required|in:admin,moderador,lectura',
            'organismo_id' => 'nullable|exists:organismos,id',
        ]);
        $user->update($validated);
        return redirect()->route('admin.users.index')->with('success', 'Usuario actualizado correctamente.');
    }

    // Método destroy puede agregarse según necesidad
}
