<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('organismos', function (Blueprint $table) {
            $table->unsignedBigInteger('parent_id')->nullable()->after('email');
            $table->foreign('parent_id')->references('id')->on('organismos')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('organismos', function (Blueprint $table) {
            $table->dropForeign(['parent_id']);
            $table->dropColumn('parent_id');
        });
    }
};
