<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('solicitudes', function (Blueprint $table) {
            // Código único de seguimiento para acceso público
            $table->string('codigo_seguimiento', 20)->unique()->nullable()->after('id');
            
            // Ruta para archivos adjuntos en el cierre (certificados, respuestas PDF, etc.)
            $table->text('uri_archivos_cierre')->nullable()->after('observaciones_cierre');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('solicitudes', function (Blueprint $table) {
            $table->dropColumn(['codigo_seguimiento', 'uri_archivos_cierre']);
        });
    }
};
