<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('gestiones', function (Blueprint $table) {
            // Ruta para archivos adjuntos en las gestiones (imágenes, documentos, etc.)
            $table->text('uri_archivos_adjuntos')->nullable()->after('descripcion_gestion');
            
            // ID del usuario que realizó la gestión
            $table->foreignId('usuario_id')->nullable()->constrained('users')->after('solicitud_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('gestiones', function (Blueprint $table) {
            $table->dropForeign(['usuario_id']);
            $table->dropColumn(['uri_archivos_adjuntos', 'usuario_id']);
        });
    }
};
