// Funcionalidad para el módulo de tipos de solicitudes

// Funciones disponibles globalmente
window.loadViewModal = function(id) {
    console.log('Ver tipo:', id);
    
    // Mostrar loading
    const modal = document.getElementById('dynamicModal');
    const modalTitle = document.getElementById('dynamicModalLabel');
    const modalContent = document.getElementById('modalContent');
    const modalFooter = document.getElementById('modalFooter');
    const submitBtn = document.getElementById('submitBtn');
    
    modalTitle.textContent = 'Cargando...';
    modalContent.innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin fa-2x"></i><p class="mt-2">Cargando detalles...</p></div>';
    submitBtn.style.display = 'none';
    
    // Mostrar modal
    $(modal).modal('show');
    
    // Realizar petición AJAX
    fetch(`/admin/tipo-solicitudes/${id}/show-ajax`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                modalTitle.textContent = data.title || 'Detalles del Tipo de Solicitud';
                modalContent.innerHTML = data.content;
            } else {
                modalContent.innerHTML = '<div class="alert alert-danger">Error al cargar los detalles.</div>';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            modalContent.innerHTML = '<div class="alert alert-danger">Error al conectar con el servidor.</div>';
        });
};

window.loadEditModal = function(id) {
    console.log('Editar tipo:', id);
    
    // Mostrar loading
    const modal = document.getElementById('dynamicModal');
    const modalTitle = document.getElementById('dynamicModalLabel');
    const modalContent = document.getElementById('modalContent');
    const modalFooter = document.getElementById('modalFooter');
    const submitBtn = document.getElementById('submitBtn');
    const dynamicForm = document.getElementById('dynamicForm');
    const methodField = document.getElementById('methodField');
    
    modalTitle.textContent = 'Cargando...';
    modalContent.innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin fa-2x"></i><p class="mt-2">Cargando formulario...</p></div>';
    submitBtn.style.display = 'none';
    
    // Mostrar modal
    $(modal).modal('show');
    
    // Realizar petición AJAX
    fetch(`/admin/tipo-solicitudes/${id}/edit-ajax`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                modalTitle.textContent = data.title || 'Editar Tipo de Solicitud';
                modalContent.innerHTML = data.content;
                
                // Configurar formulario para edición
                dynamicForm.action = `/admin/tipo-solicitudes/${id}`;
                methodField.value = 'PUT';
                submitBtn.style.display = 'inline-block';
                submitBtn.textContent = 'Actualizar';
                
                // Manejar envío del formulario
                setupFormSubmission();
            } else {
                modalContent.innerHTML = '<div class="alert alert-danger">Error al cargar el formulario.</div>';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            modalContent.innerHTML = '<div class="alert alert-danger">Error al conectar con el servidor.</div>';
        });
};

document.addEventListener('DOMContentLoaded', function() {
    // Manejar confirmación de eliminación
    initDeleteConfirmation();
    
    // Manejar notificaciones
    handleNotifications();
});

function initDeleteConfirmation() {
    document.querySelectorAll('.delete-tipo-form').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            Swal.fire({
                title: '¿Estás seguro?',
                text: 'Esta acción no se puede deshacer.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
}

function handleNotifications() {
    if (window.successMessage) {
        Swal.fire({
            icon: 'success',
            title: '¡Éxito!',
            text: window.successMessage,
            timer: 3000,
            showConfirmButton: false
        });
    }
    
    if (window.errorMessage) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: window.errorMessage
        });
    }
    
    if (window.errorMessages) {
        Swal.fire({
            icon: 'error',
            title: 'Errores de validación',
            html: window.errorMessages
        });
    }
}

function setupFormSubmission() {
    const dynamicForm = document.getElementById('dynamicForm');
    const modal = document.getElementById('dynamicModal');
    
    // Remover listeners anteriores
    dynamicForm.replaceWith(dynamicForm.cloneNode(true));
    const newForm = document.getElementById('dynamicForm');
    
    newForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const submitBtn = document.getElementById('submitBtn');
        const originalText = submitBtn.textContent;
        
        // Mostrar loading en botón
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Guardando...';
        
        // Preparar datos del formulario
        const formData = new FormData(newForm);
        
        // Realizar petición
        fetch(newForm.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || formData.get('_token')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Cerrar modal
                $(modal).modal('hide');
                
                // Mostrar mensaje de éxito
                Swal.fire({
                    icon: 'success',
                    title: '¡Éxito!',
                    text: data.message || 'Operación completada correctamente.',
                    timer: 3000,
                    showConfirmButton: false
                });
                
                // Recargar página para mostrar cambios
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            } else {
                // Mostrar errores
                let errorMessage = 'Ocurrió un error al procesar la solicitud.';
                if (data.errors) {
                    errorMessage = Object.values(data.errors).flat().join('\n');
                } else if (data.message) {
                    errorMessage = data.message;
                }
                
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: errorMessage
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Error al conectar con el servidor.'
            });
        })
        .finally(() => {
            // Restaurar botón
            submitBtn.disabled = false;
            submitBtn.textContent = originalText;
        });
    });
}
