@extends('layouts.admin')

@section('content')
<div class="mt-4">
    <h2 class="text-gray font-weight-bold mb-4">Solicitudes Ingresadas</h2>
    
    @include('admin.solicitudes.partials.filters')
    
    <div class="admin-responsive-table table-scroll-indicator">
        <table class="table table-hover align-middle table-sm">
            <thead class="thead-light">
                <tr>
                    <th class="text-center">#</th>
                    <th>Tipo</th>
                    <th class="expandable-cell">Organismo</th>
                    <th>Estado</th>
                    <th>Fecha</th>
                    <th class="text-center">Días</th>
                    <th>Gestor</th>
                    <th class="text-center actions-cell">Acciones</th>
                </tr>
            </thead>
        <tbody>
            @foreach($solicitudes as $solicitud)
                <tr class="{{ $solicitud->estado == 'cerrada' ? 'solicitud-cerrada' : '' }}">
                    <td class="text-center">{{ $solicitud->id }}</td>
                    <td>{{ $solicitud->tipoSolicitud->denominacion ?? '-' }}</td>
                    <td style="text-transform: lowercase;">{{ $solicitud->organismoRequeridor->nombre ?? '-' }}</td>
                    <td>
                        @include('admin.solicitudes.partials.estado-badge', ['solicitud' => $solicitud])
                    </td>
                    <td>{{ \Carbon\Carbon::parse($solicitud->fecha_solicitud)->format('Y-m-d') }}</td>
                    <td class="text-center">
                        @include('admin.solicitudes.partials.tiempo-restante', ['solicitud' => $solicitud])
                    </td>
                    <td>{{ $solicitud->gestor?->name ?? '-' }}</td>
                    <td class="text-center">
                        @include('admin.solicitudes.partials.table-actions', ['solicitud' => $solicitud])
                        @include('admin.solicitudes.partials.modal-resumen', ['solicitud' => $solicitud])
                        @include('admin.solicitudes.partials.modal-gestion-completa', ['solicitud' => $solicitud])
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    </div>
    
    <div class="d-flex justify-content-between align-items-center mt-3">
        <div class="text-muted">
            <small>
                Mostrando {{ $solicitudes->firstItem() }} - {{ $solicitudes->lastItem() }} 
                de {{ $solicitudes->total() }} solicitudes 
                (Página {{ $solicitudes->currentPage() }} de {{ $solicitudes->lastPage() }})
            </small>
        </div>
        <div>
            {{ $solicitudes->appends(request()->query())->links() }}
        </div>
    </div>
</div>
@endsection

@section('styles')
<link rel="stylesheet" href="{{ asset('css/solicitudes-index.css') }}">
@endsection

@section('scripts')
<script src="{{ asset('js/solicitudes-index.js') }}"></script>
@endsection
