{{-- Información General de la Solicitud --}}
<div class="card shadow-sm border-0 mb-4">
    <div class="card-header bg-light">
        <h6 class="mb-0 text-primary"><i class="fas fa-info-circle mr-2"></i>Información General</h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="text-muted small mb-1">Tipo de Solicitud</label>
                <div class="font-weight-bold">{{ $solicitud->tipoSolicitud->denominacion ?? '-' }}</div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="text-muted small mb-1">Organismo Requeridor</label>
                <div class="font-weight-bold">{{ $solicitud->organismoRequeridor->nombre ?? '-' }}</div>
            </div>
            <div class="col-md-4 mb-3">
                <label class="text-muted small mb-1">Estado</label>
                <div>
                    @include('admin.solicitudes.partials.estado-badge', ['solicitud' => $solicitud])
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <label class="text-muted small mb-1">Fecha de Solicitud</label>
                <div>{{ \Carbon\Carbon::parse($solicitud->fecha_solicitud)->format('d/m/Y') }}</div>
            </div>
            <div class="col-md-4 mb-3">
                <label class="text-muted small mb-1">Tiempo Restante</label>
                <div>
                    @include('admin.solicitudes.partials.tiempo-restante', ['solicitud' => $solicitud])
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="text-muted small mb-1">Gestor Asignado</label>
                <div>
                    @if($solicitud->gestor)
                        <span class="badge badge-secondary"><i class="fas fa-user mr-1"></i>{{ $solicitud->gestor->name }}</span>
                    @else
                        <span class="text-muted">Sin asignar</span>
                    @endif
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="text-muted small mb-1">Fecha de Asignación</label>
                <div>{{ $solicitud->fecha_asignacion ? \Carbon\Carbon::parse($solicitud->fecha_asignacion)->format('d/m/Y H:i') : '-' }}</div>
            </div>
        </div>
    </div>
</div>
