@extends('layouts.admin')

@section('title', 'Crear Tipo de Solicitud')

@push('styles')
    <link rel="stylesheet" href="{{ asset('css/admin.css') }}">
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        window.successMessage = @json(session('success'));
        window.errorMessages = @json($errors->any() ? implode('<br>', $errors->all()) : null);
    </script>
    <script src="{{ asset('js/admin-tipos-form.js') }}"></script>
@endpush

@section('content')
    <div class="admin-header">
        <h2 class="page-title">Nuevo Tipo de Solicitud</h2>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.tipo-solicitudes.store') }}" method="POST" class="needs-validation" novalidate>
                @csrf
                
                <div class="mb-3">
                    <label for="denominacion" class="form-label">Denominación <span class="text-danger">*</span></label>
                    <input type="text" 
                           name="denominacion" 
                           id="denominacion" 
                           class="form-control @error('denominacion') is-invalid @enderror" 
                           value="{{ old('denominacion') }}" 
                           required
                           maxlength="255">
                    @error('denominacion')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="descripcion" class="form-label">Descripción</label>
                    <textarea name="descripcion" 
                              id="descripcion" 
                              class="form-control @error('descripcion') is-invalid @enderror" 
                              rows="4"
                              maxlength="1000"
                              placeholder="Descripción opcional del tipo de solicitud">{{ old('descripcion') }}</textarea>
                    @error('descripcion')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-4">
                    <label for="activo" class="form-label">Estado</label>
                    <select name="activo" id="activo" class="form-select @error('activo') is-invalid @enderror">
                        <option value="1" {{ old('activo', '1') == '1' ? 'selected' : '' }}>Activo</option>
                        <option value="0" {{ old('activo') == '0' ? 'selected' : '' }}>Inactivo</option>
                    </select>
                    @error('activo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="d-flex justify-content-between">
                    <a href="{{ route('admin.tipo-solicitudes.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i>Volver
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>Guardar
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
