{{-- Vista de detalles para el modal --}}
<div class="row">
    <div class="col-md-6">
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-primary text-white">
                <i class="fas fa-tag"></i> Identidad del Tipo de Solicitud
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <span class="fw-bold">ID:</span>
                    <span class="ms-2">{{ $tipo->id }}</span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Denominación:</span>
                    <span class="ms-2">{{ $tipo->denominacion }}</span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Estado:</span>
                    <span class="ms-2">
                        <span class="badge {{ $tipo->activo ? 'bg-success' : 'bg-danger' }}">
                            {{ $tipo->activo ? 'Activo' : 'Inactivo' }}
                        </span>
                    </span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-info text-white">
                <i class="fas fa-align-left"></i> Descripción
            </div>
            <div class="card-body">
                <span>{{ $tipo->descripcion ?: 'Sin descripción' }}</span>
            </div>
        </div>
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-light text-dark">
                <i class="fas fa-calendar-alt"></i> Fechas
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <span class="fw-bold">Creado:</span>
                    <span class="ms-2">{{ $tipo->created_at->format('d/m/Y H:i') }}</span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Actualizado:</span>
                    <span class="ms-2">{{ $tipo->updated_at->format('d/m/Y H:i') }}</span>
                </div>
            </div>
        </div>
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-success text-white">
                <i class="fas fa-tasks"></i> Solicitudes Asociadas
            </div>
            <div class="card-body">
                <span>{{ $tipo->solicitudes()->count() }} solicitud(es)</span>
            </div>
        </div>
    </div>
</div>
