@extends('layouts.admin')

@section('title', 'Editar Usuario')

@push('styles')
    @vite(['resources/css/admin-users-form.css'])
@endpush

@section('content')
<div class="user-form-card">
    <div class="user-form-header">
        <h3>Editar Usuario: {{ $user->first_name }} {{ $user->last_name }}</h3>
    </div>
    
    <div class="user-form-body">
        <x-validation-errors />
        
        <form action="{{ route('admin.users.update', $user->id) }}" method="POST" id="userEditForm">
            @csrf
            @method('PUT')
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="first_name" class="form-label required">Nombres</label>
                        <input type="text" 
                               class="form-control" 
                               id="first_name" 
                               name="first_name" 
                               value="{{ old('first_name', $user->first_name) }}"
                               required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="last_name" class="form-label required">Apellidos</label>
                        <input type="text" 
                               class="form-control" 
                               id="last_name" 
                               name="last_name" 
                               value="{{ old('last_name', $user->last_name) }}"
                               required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="email" class="form-label required">Email</label>
                        <input type="email" 
                               class="form-control" 
                               id="email" 
                               name="email" 
                               value="{{ old('email', $user->email) }}"
                               required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="telefono" class="form-label">Teléfono</label>
                        <input type="text" 
                               class="form-control" 
                               id="telefono" 
                               name="telefono"
                               value="{{ old('telefono', $user->telefono) }}">
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="role" class="form-label required">Rol</label>
                        <select class="form-control form-select" 
                                id="role" 
                                name="role" 
                                required>
                            <option value="">Seleccionar rol</option>
                            <option value="admin" {{ (old('role', $user->role) == 'admin') ? 'selected' : '' }}>Administrador</option>
                            <option value="moderador" {{ (old('role', $user->role) == 'moderador') ? 'selected' : '' }}>Moderador</option>
                            <option value="lectura" {{ (old('role', $user->role) == 'lectura') ? 'selected' : '' }}>Solo Lectura</option>
                        </select>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="organismo_id" class="form-label">Organismo</label>
                        <select class="form-control form-select" 
                                id="organismo_id" 
                                name="organismo_id">
                            <option value="">Sin organismo</option>
                            @foreach($organismos as $organismo)
                                <option value="{{ $organismo->id }}" 
                                        {{ (old('organismo_id', $user->organismo_id) == $organismo->id) ? 'selected' : '' }}>
                                    {{ $organismo->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="password" class="form-label">Nueva Contraseña</label>
                        <input type="password" 
                               class="form-control" 
                               id="password" 
                               name="password">
                        <small class="form-text text-muted">Dejar en blanco para no cambiar la contraseña actual</small>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="password_confirmation" class="form-label">Confirmar Nueva Contraseña</label>
                        <input type="password" 
                               class="form-control" 
                               id="password_confirmation" 
                               name="password_confirmation">
                    </div>
                </div>
            </div>
            
            <div class="form-buttons">
                <button type="submit" class="btn btn-submit">
                    <i class="fas fa-save"></i> Actualizar Usuario
                </button>
                <a href="{{ route('admin.users.index') }}" class="btn btn-cancel">
                    <i class="fas fa-arrow-left"></i> Volver
                </a>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
    @vite(['resources/js/admin-users-form.js'])
    <script>
        // Variables globales para el contexto
        window.successMessage = @json(session('success'));
        window.errorMessage = @json(session('error'));
        window.errorMessages = @json($errors->any() ? implode('<br>', $errors->all()) : null);
        
        // Para formulario de edición, la contraseña no es requerida
        document.addEventListener('DOMContentLoaded', function() {
            const passwordField = document.getElementById('password');
            const confirmPasswordField = document.getElementById('password_confirmation');
            
            if (passwordField) {
                passwordField.removeAttribute('required');
            }
            if (confirmPasswordField) {
                confirmPasswordField.removeAttribute('required');
            }
        });
    </script>
@endpush
