{{-- filepath: resources/views/layouts/confirmation.blade.php --}}
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'Sistema de Solicitudes')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Google Fonts: Inter -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome para iconos -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="{{ asset('css/root.css') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    @stack('styles')
</head>

<body>
    <div style="width: 100%; max-width: 800px; margin: 2rem auto; padding: 0 1rem;">
        @yield('content')
        
        {{-- Toasts globales --}}
        @php
            $toastScripts = [];
            if(session('success')) {
                $toastScripts[] = "showToast({text: " . json_encode(session('success')) . ", icon: 'success', timer: 4000});";
            }
            if(session('error')) {
                $toastScripts[] = "showToast({text: " . json_encode(session('error')) . ", icon: 'error', timer: 5000});";
            }
            foreach($errors->all() as $error) {
                $toastScripts[] = "showToast({text: " . json_encode($error) . ", icon: 'error', timer: 5000});";
            }
        @endphp
        @if(count($toastScripts))
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    {!! implode("\n                    ", $toastScripts) !!}
                });
            </script>
        @endif
    </div>
    
    <!-- SweetAlert2 (para toast) -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="/js/toast-handler.js"></script>
    @stack('scripts')
</body>

</html>