@extends('layouts.app')
@section('title', 'Seguimiento de Solicitud')

@section('content')
<div class="siac-app-card siac-view-seguimiento">
    <form class="siac-form" action="{{ route('seguimiento.consultar') }}" method="POST">
        @csrf
        
        <!-- Título simplificado sin badge -->
        <h1 class="siac-search-title">Seguimiento de Solicitud</h1>
        
        <div>
            <label class="siac-form-label" for="codigo_seguimiento">Código de Seguimiento</label>
            <input type="text" name="codigo_seguimiento" id="codigo_seguimiento" class="siac-form-input" 
                   value="{{ old('codigo_seguimiento') }}" 
                   placeholder="Ej: SIAC-20250726-A1B2" 
                   style="text-transform: uppercase;"
                   required>
            <div class="form-field-info">
                Ingrese el código de seguimiento que recibió por correo electrónico al crear su solicitud.
            </div>

            @if($errors->has('codigo_seguimiento'))
                <div class="error-message">
                    {{ $errors->first('codigo_seguimiento') }}
                </div>
            @endif
        </div>

        <button type="submit" class="siac-form-btn">Buscar Solicitud</button>
    </form>

    <!-- Panel Institucional Simplificado -->
    <div class="siac-info-panel">
        <img src="/images/logo.png" alt="Logo Municipalidad de Loncoche" class="logo-muni">
        <div class="siac-info-title">Municipalidad de Loncoche</div>
        <div class="siac-info-subtitle">Sistema de Información y Atención Ciudadana</div>
    </div>
</div>

<script>
// Convertir a mayúsculas automáticamente
document.getElementById('codigo_seguimiento').addEventListener('input', function(e) {
    e.target.value = e.target.value.toUpperCase();
});

// Mostrar toast para mensajes de error o validación
document.addEventListener('DOMContentLoaded', function() {
    @if(session('error'))
        showErrorToast('{{ session('error') }}');
    @endif
    
    @if($errors->has('codigo_seguimiento'))
        showWarningToast('{{ $errors->first('codigo_seguimiento') }}');
    @endif
});
</script>
@endsection
