@extends('layouts.app')
@section('title', 'Detalle de Solicitud - ' . $solicitud->codigo_seguimiento)

@section('content')
<div class="siac-app-card siac-view-seguimiento-detalle" style="margin-bottom: 6rem;">
    <div class="siac-form">
        <div class="siac-form-label-title">
            Seguimiento de Solicitud {{ $solicitud->codigo_seguimiento }}
        </div>
        
        <div style="margin-bottom: 2rem; border-bottom: 1px solid var(--clr-input-border); padding-bottom: 1rem;"></div>
        
        <!-- Estado de la Solicitud -->
        <div style="margin-bottom: 2rem;">
            <h3 style="color: #1a3766; margin-bottom: 1rem;">Estado Actual</h3>
            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1rem;">
                <span style="padding: 0.5rem 1rem; border-radius: 20px; font-weight: 600; 
                    @if($solicitud->estado === 'pendiente') background: #ffc107; color: #1a3766;
                    @elseif($solicitud->estado === 'en_gestion') background: #007bff; color: white;
                    @elseif($solicitud->estado === 'cerrada') background: #28a745; color: white;
                    @else background: #6c757d; color: white; @endif">
                    @switch($solicitud->estado)
                        @case('pendiente') Pendiente @break
                        @case('en_gestion') En Gestión @break
                        @case('cerrada') Cerrada @break
                        @default {{ ucfirst($solicitud->estado) }}
                    @endswitch
                </span>
                @if($solicitud->gestor)
                    <span style="color: #666;">Gestor: {{ $solicitud->gestor->name }}</span>
                @endif
            </div>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem;">
                <div>
                    <strong>Fecha de Solicitud:</strong><br>
                    {{ $solicitud->created_at->format('d/m/Y H:i') }}
                </div>
                @if($solicitud->fecha_asignacion)
                <div>
                    <strong>Fecha de Asignación:</strong><br>
                    {{ $solicitud->fecha_asignacion->format('d/m/Y H:i') }}
                </div>
                @endif
                @if($solicitud->fecha_cierre)
                <div>
                    <strong>Fecha de Cierre:</strong><br>
                    {{ $solicitud->fecha_cierre->format('d/m/Y H:i') }}
                </div>
                @endif
            </div>
        </div>

        <!-- Detalles de la Solicitud -->
        <div style="margin-bottom: 2rem;">
            <h3 style="color: #1a3766; margin-bottom: 1rem;">Detalles de la Solicitud</h3>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; margin-bottom: 1rem;">
                <div>
                    <strong>Tipo:</strong><br>
                    {{ $solicitud->tipoSolicitud->denominacion ?? 'No especificado' }}
                </div>
                <div>
                    <strong>Organismo:</strong><br>
                    {{ $solicitud->organismoRequeridor->nombre ?? 'No especificado' }}
                </div>
                <div>
                    <strong>Solicitante:</strong><br>
                    {{ $solicitud->nombres }} {{ $solicitud->apellido_paterno }} {{ $solicitud->apellido_materno }}
                </div>
            </div>
            
            <div style="margin-bottom: 1rem;">
                <strong>Detalle de la Solicitud:</strong><br>
                <div style="background: #f8f9fa; padding: 1rem; border-radius: 8px; margin-top: 0.5rem;">
                    {{ $solicitud->detalle_solicitud }}
                </div>
            </div>

            @if($solicitud->observaciones)
            <div style="margin-bottom: 1rem;">
                <strong>Observaciones:</strong><br>
                <div style="background: #f8f9fa; padding: 1rem; border-radius: 8px; margin-top: 0.5rem;">
                    {{ $solicitud->observaciones }}
                </div>
            </div>
            @endif
        </div>

        <!-- Historial de Gestiones -->
        @if($solicitud->gestiones->count() > 0)
        <div style="margin-bottom: 2rem;">
            <h3 style="color: #1a3766; margin-bottom: 1rem;">Historial de Gestiones</h3>
            @foreach($solicitud->gestiones->sortByDesc('fecha_gestion') as $gestion)
            <div style="background: #f8f9fa; padding: 1rem; border-radius: 8px; margin-bottom: 1rem; border-left: 4px solid #007bff;">
                <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 0.5rem;">
                    <strong style="color: #1a3766;">{{ $gestion->usuario->name ?? 'Sistema' }}</strong>
                    <span style="color: #666; font-size: 0.9rem;">{{ $gestion->fecha_formateada }}</span>
                </div>
                <p style="margin: 0; color: #333;">{{ $gestion->descripcion_gestion }}</p>
                
                @if($gestion->uri_archivos_adjuntos && file_exists($gestion->uri_archivos_adjuntos))
                    @php
                        $archivosGestion = [];
                        if (is_dir($gestion->uri_archivos_adjuntos)) {
                            $files = scandir($gestion->uri_archivos_adjuntos);
                            foreach ($files as $file) {
                                if ($file !== '.' && $file !== '..' && is_file($gestion->uri_archivos_adjuntos . '/' . $file)) {
                                    $archivosGestion[] = $file;
                                }
                            }
                        }
                    @endphp
                    
                    @if(count($archivosGestion) > 0)
                    <div style="margin-top: 0.5rem;">
                        <small style="color: #666;">Archivos adjuntos:</small>
                        <ul style="margin: 0.25rem 0 0 1rem; padding: 0;">
                            @foreach($archivosGestion as $archivo)
                            <li style="color: #007bff;">{{ $archivo }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                @endif
            </div>
            @endforeach
        </div>
        @endif

        <!-- Observaciones de Cierre -->
        @if($solicitud->estado === 'cerrada' && $solicitud->observaciones_cierre)
        <div style="margin-bottom: 2rem;">
            <h3 style="color: #1a3766; margin-bottom: 1rem;">Resolución</h3>
            <div style="background: #d4edda; padding: 1rem; border-radius: 8px; border-left: 4px solid #28a745;">
                {{ $solicitud->observaciones_cierre }}
            </div>
            
            @if(count($archivosCierre) > 0)
            <div style="margin-top: 1rem;">
                <strong>Documentos de Respuesta:</strong>
                <ul style="margin: 0.5rem 0 0 1rem; padding: 0;">
                    @foreach($archivosCierre as $archivo)
                    <li style="margin-bottom: 0.25rem;">
                        <a href="{{ route('seguimiento.descargar-archivo-cierre', ['codigo' => $solicitud->codigo_seguimiento, 'filename' => $archivo['name']]) }}" 
                           style="color: #007bff; text-decoration: none;">
                            📄 {{ $archivo['name'] }}
                        </a>
                        <small style="color: #666;">({{ number_format($archivo['size']/1024, 1) }} KB)</small>
                    </li>
                    @endforeach
                </ul>
            </div>
            @endif
        </div>
        @endif

        <div style="text-align: center; margin-top: 2rem;">
            <a href="{{ route('seguimiento.buscar') }}" class="siac-form-btn" style="background: #6c757d; text-decoration: none;">
                ← Buscar Otra Solicitud
            </a>
        </div>
    </div>

    <!-- Panel Institucional -->
    <div class="siac-info-panel">
        <img src="{{ asset('images/logo.png') }}" alt="Logo SIAC" class="logo-muni">
        <div class="siac-info-title">Estado de Solicitud</div>
        <div class="siac-info-subtitle">Sistema Integral de Atención Ciudadana</div>
        <div class="siac-info-desc">
            Aquí puede ver el estado actual y el historial completo de su solicitud. 
            Si tiene consultas adicionales, puede contactarnos a través de los medios oficiales.
        </div>
        <img src="{{ asset('images/logo-copihue.png') }}" alt="Loncoche" class="siac-info-img">
    </div>
</div>
@endsection
