@extends('layouts.app')

@section('content')
@php
    $step1 = session('solicitud.details', []);
    $step2 = session('solicitud.contact', []);
    $step3 = session('solicitud.statistics', []);
@endphp

<div class="siac-app-card siac-view-summary" style="margin-bottom: 6rem;">
    <div class="siac-form">
        <div class="siac-form-label-title">
            Resumen de Solicitud
        </div>
        
        <div style="margin-bottom: 2rem; border-bottom: 1px solid var(--clr-input-border); padding-bottom: 1rem;"></div>
        
        <form method="POST" action="{{ route('solicitudes.storeSummary') }}">
            @csrf
            
            <!-- Sección 1: Detalles de la Solicitud -->
            <div style="margin-bottom: 2rem;">
                <div class="siac-form-label">
                    1. Detalles de la Solicitud
                </div>
                <div style="background: var(--clr-input-bg); border: 1.5px solid var(--clr-input-border); border-radius: 0 0 8px 8px; padding: 1rem;">
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; margin-bottom: 1rem;">
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Tipo de Solicitud</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $tipoSolicitud ? $tipoSolicitud->denominacion : 'No especificado' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Organismo Requerido</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $organismo ? $organismo->nombre : 'No especificado' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Notificación por Email</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ isset($step1['notificacion']) && $step1['notificacion'] ? 'Sí' : 'No' }}</span>
                        </div>
                    </div>
                    <div style="margin-bottom: 1rem; min-width: 0;">
                        <strong style="color: var(--clr-primary-text);">Detalle Solicitud</strong><br>
                        <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word; white-space: pre-wrap;">{{ $step1['detalle_solicitud'] ?? '' }}</span>
                    </div>
                    <div style="min-width: 0;">
                        <strong style="color: var(--clr-primary-text);">Observaciones</strong><br>
                        <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word; white-space: pre-wrap;">{{ $step1['observaciones'] ?? '' }}</span>
                    </div>
                </div>
            </div>

            <!-- Sección 2: Datos de Contacto -->
            <div style="margin-bottom: 2rem;">
                <div class="siac-form-label">
                    2. Datos de Contacto
                </div>
                <div style="background: var(--clr-input-bg); border: 1.5px solid var(--clr-input-border); border-radius: 0 0 8px 8px; padding: 1rem;">
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; margin-bottom: 1rem;">
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Nombres</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['nombres'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Apellido Paterno</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['apellido_paterno'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Apellido Materno</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['apellido_materno'] ?? '' }}</span>
                        </div>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; margin-bottom: 1rem;">
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Nacionalidad</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['nacionalidad'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">País de residencia</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['pais_residencia'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Calle</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['calle'] ?? '' }}</span>
                        </div>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; margin-bottom: 1rem;">
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Número</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['numero'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Villa / Población / Departamento</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['villa'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Comuna</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['comuna'] ?? '' }}</span>
                        </div>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem;">
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Teléfono</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['telefono'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Email</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step2['email'] ?? '' }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sección 3: Datos Estadísticos -->
            <div style="margin-bottom: 2rem;">
                <div class="siac-form-label">
                    3. Datos Estadísticos (Opcional)
                </div>
                <div style="background: var(--clr-input-bg); border: 1.5px solid var(--clr-input-border); border-radius: 0 0 8px 8px; padding: 1rem;">
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; margin-bottom: 1rem;">
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Tipo de Zona</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step3['tipo_zona'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Educación</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step3['educacion'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Edad</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step3['edad'] ?? '' }}</span>
                        </div>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; margin-bottom: 1rem;">
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Ocupación</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step3['ocupacion'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Género</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step3['genero'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Organización</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step3['organizacion'] ?? '' }}</span>
                        </div>
                    </div>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem;">
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Apoderado</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step3['apoderado'] ?? '' }}</span>
                        </div>
                        <div style="min-width: 0; overflow-wrap: break-word; word-wrap: break-word;">
                            <strong style="color: var(--clr-primary-text);">Usuario desea respuesta mediante</strong><br>
                            <span style="color: var(--clr-secondary-text); word-break: break-word; overflow-wrap: break-word;">{{ $step3['usuario_respuesta'] ?? '' }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sección 4: Evidencias (si existen) -->
            @if(isset($evidenciaFiles) && count($evidenciaFiles) > 0)
            <div style="margin-bottom: 2rem;">
                <div class="siac-form-label">
                    4. Archivos de Evidencia
                </div>
                <div style="background: var(--clr-input-bg); border: 1.5px solid var(--clr-input-border); border-radius: 0 0 8px 8px; padding: 1rem;">
                    <div style="display: grid; gap: 0.5rem;">
                        @foreach($evidenciaFiles as $index => $file)
                        <div style="display: flex; align-items: center; gap: 1rem; padding: 0.5rem; background: rgba(255, 255, 255, 0.5); border-radius: 4px; border: 1px solid #e0e0e0; min-width: 0;">
                            <div style="flex: 1; min-width: 0;">
                                <strong style="color: var(--clr-primary-text); word-break: break-word; overflow-wrap: break-word;">{{ $file['original_name'] }}</strong>
                                <br>
                                <small style="color: var(--clr-secondary-text);">
                                    Tamaño: {{ number_format($file['size'] / 1024, 1) }} KB | 
                                    Tipo: {{ $file['mime_type'] }}
                                </small>
                            </div>
                            <div style="color: #28a745; font-size: 1.2em;">
                                ✓
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div style="margin-top: 1rem; padding: 0.75rem; background: rgba(40, 167, 69, 0.1); border: 1px solid rgba(40, 167, 69, 0.3); border-radius: 4px;">
                        <strong style="color: #155724;">Total de archivos: {{ count($evidenciaFiles) }}</strong>
                        <br>
                        <small style="color: #155724;">Los archivos de evidencia se adjuntarán a su solicitud cuando la envíe.</small>
                    </div>
                </div>
            </div>
            @endif
            
            <!-- Campos ocultos para enviar toda la data -->
            @foreach ($step1 as $key => $value)
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
            @endforeach
            @foreach ($step2 as $key => $value)
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
            @endforeach
            @foreach ($step3 as $key => $value)
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
            @endforeach
            
            <div class="siac-form-actions">
                <a href="{{ route('solicitudes.reset') }}" class="siac-form-btn-restart" onclick="return confirm('¿Está seguro de que desea reiniciar el formulario? Se perderán todos los datos ingresados.')">
                    <i class="fas fa-redo"></i> Reiniciar
                </a>
                <button type="submit" class="siac-form-btn siac-form-btn-submit">
                    <i class="fas fa-paper-plane"></i> Enviar Solicitud
                </button>
            </div>
        </form>
    </div>

    <div class="siac-info-panel">
        <img src="{{ asset('images/logo.png') }}" alt="Logo SIAC" class="logo-muni">
        <div class="siac-info-title">Resumen de Solicitud</div>
        <div class="siac-info-subtitle">Sistema Integral de Atención Ciudadana</div>
        <div class="siac-info-desc">
            Revise cuidadosamente toda la información ingresada antes de enviar su solicitud. 
            Una vez enviada, recibirá un correo de confirmación con un número de seguimiento para consultar el estado de su trámite.
        </div>
        <img src="{{ asset('images/logo-copihue.png') }}" alt="Copihue" class="siac-info-img">
    </div>
</div>
@endsection

@push('styles')
<link rel="stylesheet" href="/css/solicitudes-form.css">
@endpush

@section('mirror-card')
<div class="siac-view-summary">
  @include('components.mirror_card', ['mirrorStep' => 'summary'])
</div>
@endsection

