<?php

use App\Http\Controllers\SolicitudController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
})->name('home');

// Formulario de creación de solicitudes con validación de pasos
Route::get('/solicitudes/create/details', [SolicitudController::class, 'createDetails'])->name('solicitudes.create.details');
Route::post('/solicitudes/details', [SolicitudController::class, 'storeDetails'])->name('solicitudes.storeDetails');

Route::get('/solicitudes/create/contact', [SolicitudController::class, 'createContact'])
    ->middleware('validate.form.step:contact')
    ->name('solicitudes.create.contact');
Route::post('/solicitudes/contact', [SolicitudController::class, 'storeContact'])
    ->middleware('validate.form.step:contact')
    ->name('solicitudes.storeContact');

Route::get('/solicitudes/create/statistics', [SolicitudController::class, 'createStatistics'])
    ->middleware('validate.form.step:statistics')
    ->name('solicitudes.create.statistics');
Route::post('/solicitudes/statistics', [SolicitudController::class, 'storeStatistics'])
    ->middleware('validate.form.step:statistics')
    ->name('solicitudes.storeStatistics');

Route::get('/solicitudes/create/summary', [SolicitudController::class, 'createSummary'])
    ->middleware('validate.form.step:summary')
    ->name('solicitudes.create.summary');
Route::post('/solicitudes/summary', [SolicitudController::class, 'storeSummary'])
    ->middleware('validate.form.step:summary')
    ->name('solicitudes.storeSummary');

// Ruta para limpiar sesión del formulario
Route::get('/solicitudes/reset', function() {
    session()->forget('solicitud');
    return redirect()->route('solicitudes.create.details')
        ->with('success', 'Formulario reiniciado. Puede comenzar una nueva solicitud.');
})->name('solicitudes.reset');

// Rutas para seguimiento público de solicitudes
Route::get('/seguimiento', function() {
    return view('seguimiento.buscar');
})->name('seguimiento.buscar');

Route::post('/seguimiento/buscar', [SolicitudController::class, 'buscarSeguimiento'])->name('seguimiento.consultar');
Route::get('/seguimiento/{codigo}', [SolicitudController::class, 'mostrarSeguimiento'])->name('seguimiento.mostrar');
Route::get('/seguimiento/{codigo}/archivo/{filename}', [SolicitudController::class, 'descargarArchivoCierre'])->name('seguimiento.descargar-archivo-cierre');

#Route::post('/solicitudes', [SolicitudController::class, 'store'])->name('solicitudes.store');
Route::prefix('admin')->name('admin.')->middleware('auth')->group(function () {
    Route::get('/', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');

    // Rutas de mantenedores (solo admin)
    Route::middleware('admin')->group(function () {
        // Rutas AJAX para tipos de solicitud
        Route::get('tipo-solicitudes/{id}/edit-ajax', [App\Http\Controllers\Admin\TipoSolicitudController::class, 'editAjax'])->name('tipo-solicitudes.edit-ajax');
        Route::get('tipo-solicitudes/{id}/show-ajax', [App\Http\Controllers\Admin\TipoSolicitudController::class, 'showAjax'])->name('tipo-solicitudes.show-ajax');

        Route::get('organismos/{id}/edit-ajax', [App\Http\Controllers\Admin\OrganismoController::class, 'editAjax'])->name('organismos.edit-ajax');
        Route::get('organismos/{id}/show-ajax', [App\Http\Controllers\Admin\OrganismoController::class, 'showAjax'])->name('organismos.show-ajax');
        Route::get('organismos/{id}/children-ajax', [App\Http\Controllers\Admin\OrganismoController::class, 'childrenAjax'])->name('organismos.children-ajax');
        Route::get('organismos/get-all-ajax', [App\Http\Controllers\Admin\OrganismoController::class, 'getAllAjax'])->name('organismos.get-all-ajax');

        Route::resource('tipo-solicitudes', App\Http\Controllers\Admin\TipoSolicitudController::class);
        Route::resource('organismos', App\Http\Controllers\Admin\OrganismoController::class);
        Route::resource('users', App\Http\Controllers\Admin\UserController::class);
    });

    // Dashboard y solicitudes (admin y moderador)
    Route::get('solicitudes', [App\Http\Controllers\Admin\SolicitudController::class, 'index'])->name('solicitudes.index');
    Route::post('solicitudes/{id}/gestionar', [App\Http\Controllers\Admin\SolicitudController::class, 'gestionar'])->name('solicitudes.gestionar');
    Route::get('solicitudes/{id}', [App\Http\Controllers\Admin\SolicitudController::class, 'show'])->name('solicitudes.show');
    Route::post('solicitudes/{id}/cerrar', [App\Http\Controllers\Admin\SolicitudController::class, 'cerrar'])->name('solicitudes.cerrar');
    Route::post('solicitudes/{id}/gestion', [App\Http\Controllers\Admin\SolicitudController::class, 'storeGestion'])->name('solicitudes.gestion.store');

    // Rutas para evidencias
    Route::get('solicitudes/{id}/evidencia/{filename}', [App\Http\Controllers\Admin\SolicitudController::class, 'downloadEvidencia'])->name('solicitudes.download-evidencia');
    Route::get('solicitudes/{id}/evidencias/download-all', [App\Http\Controllers\Admin\SolicitudController::class, 'downloadAllEvidencias'])->name('solicitudes.download-all-evidencias');

    // Nueva ruta para descargar archivos adjuntos de gestión
    Route::get('gestiones/{gestion}/archivo/{filename}', [App\Http\Controllers\Admin\SolicitudController::class, 'downloadGestionArchivo'])->name('gestiones.download-archivo');
});

// Registro de admin inicial (solo si no hay usuarios y con clave especial)
Route::get('/register-admin', [App\Http\Controllers\Auth\RegisterAdminController::class, 'showForm'])->name('register.admin.form');
Route::post('/register-admin', [App\Http\Controllers\Auth\RegisterAdminController::class, 'store'])->name('register.admin.store');

// Ruta para mostrar la vista de solicitud enviada
Route::get('/solicitudes/enviada', function () {
    return view('solicitudes.solicitud_enviada');
})->name('solicitudes.enviada');

// Fallback para 404
Route::fallback(function () {
    return response()->view('errors.404', [], 404);
});

Route::get('/admin/test-layout', function () {
    return view('admin.test_layout');
});

// Login y logout
Route::get('/login', [App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [App\Http\Controllers\Auth\LoginController::class, 'login']);
Route::post('/logout', [App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');