<?php $__env->startSection('content'); ?>
<div class="card card-primary card-outline mt-4">
    <div class="card-header">
        <h3 class="card-title">Gestión de Solicitud #<?php echo e($solicitud->id); ?></h3>
    </div>
    <div class="card-body">
        <div class="row mb-3">
            <div class="col-md-6">
                <strong>Tipo:</strong> <?php echo e($solicitud->tipoSolicitud->denominacion ?? '-'); ?><br>
                <strong>Organismo:</strong> <?php echo e($solicitud->organismoRequeridor->nombre ?? '-'); ?><br>
                <strong>Estado:</strong> <?php echo e(ucfirst($solicitud->estado)); ?><br>
                <strong>Fecha:</strong> <?php echo e($solicitud->fecha_solicitud); ?><br>
                <strong>Gestor:</strong> <?php echo e($solicitud->gestor?->name ?? '-'); ?><br>
            </div>
            <div class="col-md-6">
                <strong>Detalle:</strong><br>
                <span><?php echo e($solicitud->detalle_solicitud); ?></span>
            </div>
        </div>
        
        <!-- Sección de Evidencias -->
        <?php if(count($evidencias) > 0): ?>
        <hr>
        <h5>Archivos de Evidencia (<?php echo e(count($evidencias)); ?>)</h5>
        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="text-muted">Archivos adjuntados por el solicitante</span>
                            <a href="<?php echo e(route('admin.solicitudes.download-all-evidencias', $solicitud->id)); ?>" 
                               class="btn btn-primary btn-sm">
                                <i class="fas fa-download"></i> Descargar Todo (ZIP)
                            </a>
                        </div>
                        
                        <div class="admin-responsive-table table-scroll-indicator">
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th class="expandable-cell">Archivo</th>
                                        <th>Tamaño</th>
                                        <th>Fecha Modificación</th>
                                        <th width="100" class="actions-cell">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $evidencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evidencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <i class="fas fa-file-alt text-secondary me-2"></i>
                                            <?php echo e($evidencia['name']); ?>

                                        </td>
                                        <td><?php echo e(number_format($evidencia['size'] / 1024, 1)); ?> KB</td>
                                        <td><?php echo e($evidencia['modified']); ?></td>
                                        <td>
                                            <a href="<?php echo e($evidencia['download_url']); ?>" 
                                               class="btn btn-outline-primary btn-sm" 
                                               title="Descargar archivo">
                                                <i class="fas fa-download"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <hr>
        <h5>Acciones Realizadas</h5>
        <?php if($solicitud->gestiones && $solicitud->gestiones->count()): ?>
            <ul class="list-group mb-3">
                <?php $__currentLoopData = $solicitud->gestiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item">
                        <strong><?php echo e($gestion->created_at->format('d/m/Y H:i')); ?>:</strong> <?php echo e($gestion->descripcion_gestion); ?>

                        <?php if($gestion->uri_archivos_adjuntos): ?>
                            <?php
                                $adjuntosPath = base_path($gestion->uri_archivos_adjuntos);
                                $files = [];
                                if (file_exists($adjuntosPath) && is_dir($adjuntosPath)) {
                                    $files = array_filter(scandir($adjuntosPath), function($f) use ($adjuntosPath) {
                                        return $f !== '.' && $f !== '..' && is_file($adjuntosPath . '/' . $f);
                                    });
                                }
                            ?>
                            <?php if(count($files) > 0): ?>
                                <div class="mt-2">
                                    <span class="text-muted" style="font-size:0.95em"><i class="fas fa-paperclip"></i> Archivos adjuntos:</span>
                                    <ul class="mb-0" style="list-style:none; padding-left:0;">
                                        <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a href="<?php echo e(route('admin.gestiones.download-archivo', ['gestion' => $gestion->id, 'filename' => $file])); ?>" target="_blank" class="btn btn-link btn-sm" style="padding:0;">
                                                    <i class="fas fa-file-alt"></i> <?php echo e($file); ?>

                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php else: ?>
            <p class="text-muted">No hay acciones registradas aún.</p>
        <?php endif; ?>
        <?php if($solicitud->estado !== 'cerrada'): ?>
        <form action="<?php echo e(route('admin.solicitudes.gestion.store', $solicitud->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-8">
                    <div class="form-group">
                        <label for="descripcion" class="font-weight-bold">
                            <i class="fas fa-edit mr-1"></i>
                            Descripción de la Acción
                        </label>
                        <textarea name="descripcion" id="descripcion" class="form-control" rows="4" 
                                  placeholder="Describa la acción realizada..." required></textarea>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="archivos_gestion" class="font-weight-bold">
                            <i class="fas fa-paperclip mr-1"></i>
                            Archivos Adjuntos (Opcional)
                        </label>
                        <input type="file" name="archivos_gestion[]" id="archivos_gestion" 
                               class="form-control-file" multiple accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.gif">
                        <small class="form-text text-muted">
                            Formatos permitidos: PDF, DOC, DOCX, JPG, JPEG, PNG, GIF. Máximo 10MB por archivo.
                        </small>
                        <div id="archivosPreview" class="mt-2"></div>
                    </div>
                    <div class="text-right mt-3">
                        <button type="submit" class="btn btn-success btn-block">
                            <i class="fas fa-save mr-2"></i>
                            Registrar Acción
                        </button>
                    </div>
                </div>
            </div>
        </form>
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const inputArchivos = document.getElementById('archivos_gestion');
            const preview = document.getElementById('archivosPreview');
            if (inputArchivos && preview) {
                inputArchivos.addEventListener('change', function() {
                    preview.innerHTML = '';
                    Array.from(this.files).forEach(file => {
                        const ext = file.name.split('.').pop().toLowerCase();
                        const allowed = ['pdf','doc','docx','jpg','jpeg','png','gif'];
                        if (!allowed.includes(ext)) {
                            preview.innerHTML += `<div class='text-danger'><i class='fas fa-exclamation-triangle'></i> Archivo no permitido: ${file.name}</div>`;
                        } else if (file.size > 10 * 1024 * 1024) {
                            preview.innerHTML += `<div class='text-danger'><i class='fas fa-exclamation-triangle'></i> Archivo demasiado grande: ${file.name}</div>`;
                        } else {
                            preview.innerHTML += `<div class='text-success'><i class='fas fa-check'></i> ${file.name} (${(file.size/1024).toFixed(1)} KB)</div>`;
                        }
                    });
                });
            }
        });
        </script>
        
        <!-- Formulario de cierre mejorado -->
        <div class="card mt-4">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0">
                    <i class="fas fa-times-circle"></i> Cerrar Solicitud
                </h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.solicitudes.cerrar', $solicitud->id)); ?>" method="POST" id="formCerrar">
                    <?php echo csrf_field(); ?>
                    <div class="form-group mb-3">
                        <label for="observaciones_cierre" class="form-label">
                            <i class="fas fa-comment"></i> Observaciones de Cierre (Opcional)
                        </label>
                        <textarea 
                            name="observaciones_cierre" 
                            id="observaciones_cierre" 
                            class="form-control" 
                            rows="4" 
                            placeholder="Escriba aquí las observaciones finales, resolución del caso, o cualquier información relevante para el solicitante..."
                        ></textarea>
                        <small class="form-text text-muted">
                            Estas observaciones serán incluidas en el correo de notificación al solicitante.
                        </small>
                    </div>
                    
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Importante:</strong> Al cerrar esta solicitud se enviará automáticamente un correo de notificación al solicitante (<?php echo e($solicitud->email ?? 'Sin email'); ?>).
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-danger" onclick="return confirmarCierre()">
                            <i class="fas fa-times-circle"></i> Cerrar Solicitud
                        </button>
                        <button type="button" class="btn btn-secondary" onclick="cancelarCierre()">
                            <i class="fas fa-ban"></i> Cancelar
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <script>
        function confirmarCierre() {
            const observaciones = document.getElementById('observaciones_cierre').value;
            let mensaje = '¿Está seguro de que desea cerrar esta solicitud?';
            
            if (observaciones.trim() === '') {
                mensaje += '\n\nNota: No ha ingresado observaciones de cierre.';
            }
            
            mensaje += '\n\nSe enviará una notificación por correo al solicitante.';
            
            return confirm(mensaje);
        }
        
        function cancelarCierre() {
            document.getElementById('observaciones_cierre').value = '';
        }
        </script>
        
        <?php endif; ?>
        <a href="<?php echo e(route('admin.solicitudes.index')); ?>" class="btn btn-secondary mt-3">Volver al listado</a>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/show.blade.php ENDPATH**/ ?>