<?php $__env->startSection('title', 'Detalles de la Solicitud'); ?>

<?php $__env->startSection('content'); ?>
  
  <div class="siac-app-card siac-view-details" style="margin-bottom: 6rem;">
    <!-- Formulario -->
    <form class="siac-form" action="<?php echo e(route('solicitudes.storeDetails')); ?>" method="POST" id="solicitud-form" enctype="multipart/form-data">
      <?php echo csrf_field(); ?>
    <div class="siac-form-label-title" style="margin-bottom:1.5rem;">Detalle de la solicitud</div>
    <label class="siac-form-label" for="tipo_solicitud_id">Tipo de solicitud</label>
    <select name="tipo_solicitud_id" id="tipo_solicitud_id" class="siac-form-select" required>
      <option value="">Seleccione opción</option>
      <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <option value="<?php echo e($tipo->id); ?>"><?php echo e($tipo->denominacion); ?></option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

    <label class="siac-form-label" for="organismo_requeridor_id">Organismo Requerido</label>
    <select name="organismo_requeridor_id" id="organismo_requeridor_id" class="siac-form-select" required>
      <option value="">Seleccione opción</option>
      <?php
    function renderOrganismos($organismos, $all, $nivel = 1)
    {
      foreach ($organismos as $org) {
        $hijos = $all->where('parent_id', $org->id);
        $prefijo = '';
        $claseNivel = '';
        if ($nivel == 2) {
          $prefijo = '— ';
          $claseNivel = 'select2-results__option--nivel2';
        } elseif ($nivel == 3) {
          $prefijo = '—— ';
          $claseNivel = 'select2-results__option--nivel3';
        } elseif ($nivel >= 4) {
          $prefijo = '——— ';
          $claseNivel = 'select2-results__option--nivel4';
        }

        if ($nivel == 1) {
          // Todos los nivel 1 como optgroup para consistencia visual (sin mayúsculas)
          $label = $org->nombre;
          echo '<optgroup label="' . e($label) . '">';
          
          if ($hijos->count() > 0) {
            renderOrganismos($hijos, $all, $nivel + 1);
          } else {
            echo '<option value="' . $org->id . '">— ' . $org->nombre . '</option>';
          }
          
          echo '</optgroup>';
        } else {
          if ($hijos->count() > 0) {
            $label = $prefijo . $org->nombre;
            echo '<optgroup label="' . e($label) . '">';
            renderOrganismos($hijos, $all, $nivel + 1);
            echo '</optgroup>';
          } else {
            $textoOpcion = $prefijo . $org->nombre;
            echo '<option value="' . $org->id . '">' . e($textoOpcion) . '</option>';
          }
        }
      }
    }
    $allOrganismos = collect($organismos);
    $rootOrganismos = $allOrganismos->where('parent_id', null);
    renderOrganismos($rootOrganismos, $allOrganismos);
    ?>
    </select>

    <label class="siac-form-label" for="notificacion">Notificación por email</label>
    <select name="notificacion" id="notificacion" class="siac-form-select" required>
      <option value="1" selected>Sí</option>
      <option value="0">No</option>
    </select>

    <label class="siac-form-label" for="detalle_solicitud">Detalle de Solicitud</label>
    <textarea name="detalle_solicitud" id="detalle_solicitud" class="siac-form-textarea" maxlength="12000"
      required><?php echo e(old('detalle_solicitud')); ?></textarea>
    <small class="text-muted">Cantidad de caracteres restantes 1.000</small>

    <label class="siac-form-label" for="observaciones">Observaciones</label>
    <textarea name="observaciones" id="observaciones" class="siac-form-textarea"
      maxlength="1000"><?php echo e(old('observaciones')); ?></textarea>
    <small class="text-muted">Cantidad de caracteres restantes 1.000</small>

    <label for="evidencia" class="siac-form-label">Subir Evidencia</label>
    <div style="margin-bottom: 1.5rem;">
      <div class="file-upload-container"
      style="border: 2px dashed var(--clr-input-border); border-radius: 8px; padding: 2rem; text-align: center; background: var(--clr-input-bg); cursor: pointer; transition: all 0.3s ease;"
      onclick="document.getElementById('evidencia').click();">
      <i class="fas fa-cloud-upload-alt"
        style="font-size: 3rem; color: var(--clr-input-border); margin-bottom: 1rem;"></i>
      <div style="font-weight: 600; color: var(--clr-primary-text); margin-bottom: 0.5rem;">
        Haga clic para seleccionar archivos o arrástrelos aquí
      </div>
      <div style="color: var(--clr-secondary-text); font-size: 0.9rem; margin-bottom: 1rem;">
        Máximo 10 archivos • Tamaño máximo por archivo: 10MB
      </div>
      <div style="color: var(--clr-secondary-text); font-size: 0.8rem;">
        Formatos permitidos: JPG, PNG, GIF, PDF, DOC, DOCX
      </div>
      </div>

      <input type="file" id="evidencia" name="evidencia[]" multiple
      accept=".jpg,.jpeg,.png,.gif,.pdf,.doc,.docx,image/jpeg,image/png,image/gif,application/pdf,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document"
      style="display: none;" onchange="handleFileSelect(this)">

      <div id="file-list" style="margin-top: 1rem; display: none;">
      <div style="font-weight: 600; color: var(--clr-primary-text); margin-bottom: 0.5rem;">
        Archivos seleccionados:
      </div>
      <div id="selected-files" style="max-height: 200px; overflow-y: auto;"></div>
      </div>

    </div>

    <div class="siac-form-actions">
      <a href="<?php echo e(route('solicitudes.reset')); ?>" class="siac-form-btn-restart" onclick="return confirm('¿Está seguro de que desea reiniciar el formulario? Se perderán todos los datos ingresados.')">
        <i class="fas fa-redo"></i> Reiniciar
      </a>
      <button type="submit" class="siac-form-btn">
        <i class="fas fa-arrow-right"></i> Continuar
      </button>
    </div>
    </form>

    <!-- Panel Institucional -->
    <div class="siac-info-panel">
    <img src="/images/logo.png" alt="Logo Municipalidad de Loncoche" class="logo-muni">
    <div class="siac-info-title">Municipalidad de Loncoche</div>
    <div class="siac-info-subtitle">Sistema de Información y Atención Ciudadana</div>
    <div class="siac-info-desc">
      El Sistema de Información y Atención Ciudadana (SIAC) es el primer punto de contacto entre usted y los organismos
      públicos. A través de este formulario puede realizar solicitudes ciudadanas que serán canalizadas y respondidas
      según la Ley 19.880.
    </div>
    <img src="/images/logo-copihue.png" alt="Loncoche" class="siac-info-img">
    </div>
  </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="/css/solicitudes-form.css">
<?php $__env->stopPush(); ?>

<style>
/* Asegurar que solo nivel 1 tenga negrita */
.siac-form-select optgroup {
  font-weight: normal;
}
.siac-form-select > optgroup {
  font-weight: bold;
}
.siac-form-select optgroup optgroup {
  font-weight: normal;
}
</style>

<?php $__env->startSection('mirror-card'); ?>
  <div class="siac-view-details">
    <?php echo $__env->make('components.mirror_card', ['mirrorStep' => 'details'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  </div>
<?php $__env->stopSection(); ?>

<script src="/resources/js/formularios-interacciones.js"></script>

<script>
  let hasValidationErrors = false;
  
  function handleFileSelect(input) {
    const files = Array.from(input.files);
    const fileList = document.getElementById('file-list');
    const selectedFiles = document.getElementById('selected-files');
    const fileUploadContainer = document.querySelector('.file-upload-container');

    // Validaciones
    const maxFiles = 10;
    const maxSize = 10 * 1024 * 1024; // 10MB
    const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'application/pdf',
      'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];
    const allowedExtensions = ['.jpg', '.jpeg', '.png', '.gif', '.pdf', '.doc', '.docx'];

    console.log('Validando archivos...');
    let errors = [];
    let validFiles = [];

    // Validar cantidad de archivos
    if (files.length > maxFiles) {
      errors.push(`Solo se permiten máximo ${maxFiles} archivos.`);
    }

    files.forEach((file, index) => {
      console.log(`Validando archivo: ${file.name}, tipo: ${file.type}, tamaño: ${file.size}`);
      
      // Validar tamaño
      if (file.size > maxSize) {
        errors.push(`${file.name}: El archivo excede el tamaño máximo de 10MB.`);
        return;
      }

      // Validar tipo de archivo (mejorado para manejar variaciones de tipo MIME)
      const extension = '.' + file.name.split('.').pop().toLowerCase();
      let typeValid = allowedTypes.includes(file.type);
      console.log(`Tipo detectado: ${file.type}, válido: ${typeValid}`);
      let extensionValid = allowedExtensions.includes(extension);
      
      // Validación adicional para casos donde el tipo MIME no se detecta correctamente
      if (!typeValid) {
        if (extension === '.jpg' || extension === '.jpeg') {
          typeValid = file.type === 'image/jpeg' || file.type === 'image/jpg' || file.type === '';
        } else if (extension === '.png') {
          typeValid = file.type === 'image/png' || file.type === '';
        } else if (extension === '.gif') {
          typeValid = file.type === 'image/gif' || file.type === '';
        } else if (extension === '.pdf') {
          typeValid = file.type === 'application/pdf' || file.type === '';
        } else if (extension === '.doc') {
          typeValid = file.type === 'application/msword' || file.type === '';
        } else if (extension === '.docx') {
          typeValid = file.type === 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' || file.type === '';
        }
      }
      
      console.log(`Archivo ${file.name}: extensión: ${extension}, tipo: ${file.type}, tipo válido: ${typeValid}, extensión válida: ${extensionValid}`);
      
      // El archivo es válido si cumple cualquiera de las dos validaciones
      if (!typeValid && !extensionValid) {
        errors.push(`${file.name}: Formato no permitido. Tipo detectado: "${file.type}", Extensión: "${extension}"`);
        return;
      }

      // Validar nombre de archivo (seguridad) - permitir más caracteres comunes incluyendo espacios
      const fileName = file.name;
      // Validar que no tenga caracteres peligrosos (solo rechazar caracteres realmente problemáticos)
      if (/[<>:"|*?\\\/]/.test(fileName)) {
        errors.push(`${file.name}: El nombre contiene caracteres no válidos (< > : " | * ? \\ /).`);
        return;
      }

      console.log(`Archivo ${file.name}: VÁLIDO`);
      validFiles.push(file);
    });

    // Actualizar estado de validación
    hasValidationErrors = errors.length > 0;

    // Mostrar errores si existen
    if (errors.length > 0) {
      let errorsHtml = '<ul style="text-align: left; margin: 0; padding-left: 20px;">';
      errors.forEach(error => {
        errorsHtml += `<li>${error}</li>`;
      });
      errorsHtml += '</ul>';
      
      showToast({
        icon: 'error',
        title: 'Errores en archivos',
        html: errorsHtml,
        timer: 6000
      });
      
      // Limpiar input si hay errores
      input.value = '';
    }

    // Mostrar archivos válidos
    if (validFiles.length > 0) {
      selectedFiles.innerHTML = '';
      validFiles.forEach((file, index) => {
        const fileSize = (file.size / 1024 / 1024).toFixed(2);
        const fileIcon = getFileIcon(file.type, file.name);

        const fileItem = document.createElement('div');
        fileItem.style.cssText = 'display: flex; align-items: center; justify-content: space-between; padding: 0.5rem; border: 1px solid var(--clr-input-border); border-radius: 4px; margin-bottom: 0.5rem; background: white;';

        fileItem.innerHTML = `
                <div style="display: flex; align-items: center; gap: 0.5rem;">
                    <i class="${fileIcon}" style="color: var(--clr-primary-text);"></i>
                    <div>
                        <div style="font-weight: 500; color: var(--clr-primary-text);">${file.name}</div>
                        <div style="font-size: 0.8rem; color: var(--clr-secondary-text);">${fileSize} MB</div>
                    </div>
                </div>
                <button type="button" onclick="removeFile(${index})" style="background: none; border: none; color: #dc3545; cursor: pointer; padding: 0.25rem;">
                    <i class="fas fa-times"></i>
                </button>
            `;

        selectedFiles.appendChild(fileItem);
      });

      fileList.style.display = 'block';
      fileUploadContainer.style.borderColor = '#28a745';
      fileUploadContainer.style.backgroundColor = '#f8f9fa';
    } else if (errors.length === 0) {
      fileList.style.display = 'none';
      fileUploadContainer.style.borderColor = 'var(--clr-input-border)';
      fileUploadContainer.style.backgroundColor = 'var(--clr-input-bg)';
      hasValidationErrors = false; // Reset validation state when no files and no errors
    }
  }

  function getFileIcon(type, name) {
    if (type.startsWith('image/')) return 'fas fa-image';
    if (type === 'application/pdf') return 'fas fa-file-pdf';
    if (type.includes('word') || name.endsWith('.doc') || name.endsWith('.docx')) return 'fas fa-file-word';
    return 'fas fa-file';
  }

  function removeFile(index) {
    const input = document.getElementById('evidencia');
    const dt = new DataTransfer();
    const files = Array.from(input.files);

    files.forEach((file, i) => {
      if (i !== index) dt.items.add(file);
    });

    input.files = dt.files;
    
    // Reset validation state
    hasValidationErrors = false;
    
    handleFileSelect(input);
  }

  // Drag and drop functionality
  document.addEventListener('DOMContentLoaded', function () {
    const dropZone = document.querySelector('.file-upload-container');
    const form = document.getElementById('solicitud-form');

    // Validar formulario antes del envío
    form.addEventListener('submit', function(e) {
      if (hasValidationErrors) {
        e.preventDefault();
        showToast({
          icon: 'error',
          title: 'No se puede enviar el formulario',
          text: 'Por favor corrija los errores en los archivos antes de continuar.',
          timer: 4000
        });
        return false;
      }
    });

    ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
      dropZone.addEventListener(eventName, preventDefaults, false);
    });

    function preventDefaults(e) {
      e.preventDefault();
      e.stopPropagation();
    }

    ['dragenter', 'dragover'].forEach(eventName => {
      dropZone.addEventListener(eventName, highlight, false);
    });

    ['dragleave', 'drop'].forEach(eventName => {
      dropZone.addEventListener(eventName, unhighlight, false);
    });

    function highlight(e) {
      dropZone.style.borderColor = '#007bff';
      dropZone.style.backgroundColor = '#e3f2fd';
    }

    function unhighlight(e) {
      dropZone.style.borderColor = 'var(--clr-input-border)';
      dropZone.style.backgroundColor = 'var(--clr-input-bg)';
    }

    dropZone.addEventListener('drop', handleDrop, false);

    function handleDrop(e) {
      const dt = e.dataTransfer;
      const files = dt.files;
      document.getElementById('evidencia').files = files;
      handleFileSelect(document.getElementById('evidencia'));
    }
  });

  $(document).ready(function() {
    // No necesitamos Select2 para esta solución
    // $('#organismo_requeridor_id').select2({...});
  });
</script>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/solicitudes/create_details.blade.php ENDPATH**/ ?>