
<div class="modal fade modal-gestion-completa" id="modalGestion<?php echo e($solicitud->id); ?>" tabindex="-1" role="dialog" aria-labelledby="modalGestionLabel<?php echo e($solicitud->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="modalGestionLabel<?php echo e($solicitud->id); ?>">
                    <i class="fas fa-tasks mr-2"></i>Gestión Completa - Solicitud #<?php echo e($solicitud->id); ?>

                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body p-0">
                <div class="container-fluid">
                    <div class="row">
                        
                        <div class="col-lg-8">
                            <div class="p-4">
                                
                                <div class="card shadow-sm border-0 mb-4">
                                    <div class="card-header bg-primary text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-info-circle mr-2"></i>
                                            Información de la Solicitud
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="info-item-modal mb-3">
                                                    <label class="text-muted small font-weight-bold">TIPO</label>
                                                    <p class="mb-0"><?php echo e($solicitud->tipoSolicitud->denominacion ?? '-'); ?></p>
                                                </div>
                                                <div class="info-item-modal mb-3">
                                                    <label class="text-muted small font-weight-bold">ORGANISMO</label>
                                                    <p class="mb-0"><?php echo e($solicitud->organismoRequeridor->nombre ?? '-'); ?></p>
                                                </div>
                                                <div class="info-item-modal mb-3">
                                                    <label class="text-muted small font-weight-bold">ESTADO</label>
                                                    <div><?php echo $__env->make('admin.solicitudes.partials.estado-badge', ['solicitud' => $solicitud], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?></div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="info-item-modal mb-3">
                                                    <label class="text-muted small font-weight-bold">FECHA</label>
                                                    <p class="mb-0">
                                                        <i class="fas fa-calendar mr-1 text-primary"></i>
                                                        <?php echo e(\Carbon\Carbon::parse($solicitud->fecha_solicitud)->format('d/m/Y H:i')); ?>

                                                    </p>
                                                </div>
                                                <div class="info-item-modal mb-3">
                                                    <label class="text-muted small font-weight-bold">GESTOR</label>
                                                    <p class="mb-0">
                                                        <i class="fas fa-user-tie mr-1 text-info"></i>
                                                        <?php echo e($solicitud->gestor?->name ?? 'Sin asignar'); ?>

                                                    </p>
                                                </div>
                                                <div class="info-item-modal">
                                                    <label class="text-muted small font-weight-bold">TIEMPO</label>
                                                    <div><?php echo $__env->make('admin.solicitudes.partials.tiempo-restante', ['solicitud' => $solicitud], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="info-item-modal mt-3">
                                            <label class="text-muted small font-weight-bold">DETALLE</label>
                                            <div class="bg-light p-3 rounded mt-2">
                                                <p class="mb-0"><?php echo e($solicitud->detalle_solicitud ?: 'Sin detalle especificado'); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="card shadow-sm border-0 mb-4">
                                    <div class="card-header bg-success text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-history mr-2"></i>
                                            Historial de Gestiones
                                            <?php if($solicitud->gestiones && $solicitud->gestiones->count()): ?>
                                                <span class="badge badge-light ml-2"><?php echo e($solicitud->gestiones->count()); ?></span>
                                            <?php endif; ?>
                                        </h6>
                                    </div>
                                    <div class="card-body p-0">
                                        <?php if($solicitud->gestiones && $solicitud->gestiones->count()): ?>
                                            <div class="timeline-container-modal p-4">
                                                <?php $__currentLoopData = $solicitud->gestiones->sortByDesc('fecha_gestion'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="timeline-item-modal mb-4">
                                                        <div class="timeline-marker-modal bg-success"></div>
                                                        <div class="timeline-content-modal">
                                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                                <span class="badge badge-success"><?php echo e($gestion->fecha_formateada); ?></span>
                                                                <?php if($gestion->usuario): ?>
                                                                    <small class="text-muted">
                                                                        <i class="fas fa-user mr-1"></i>
                                                                        <?php echo e($gestion->usuario->name); ?>

                                                                    </small>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="bg-light p-3 rounded">
                                                                <p class="mb-0"><?php echo e($gestion->descripcion_gestion); ?></p>
                                                                <?php if($gestion->uri_archivos_adjuntos): ?>
                                                                    <?php
                                                                        $adjuntosPath = base_path($gestion->uri_archivos_adjuntos);
                                                                        $files = [];
                                                                        if (file_exists($adjuntosPath) && is_dir($adjuntosPath)) {
                                                                            $files = array_filter(scandir($adjuntosPath), function($f) use ($adjuntosPath) {
                                                                                return $f !== '.' && $f !== '..' && is_file($adjuntosPath . '/' . $f);
                                                                            });
                                                                        }
                                                                    ?>
                                                                    <?php if(count($files) > 0): ?>
                                                                        <div class="mt-3">
                                                                            <small class="text-muted font-weight-bold">
                                                                                <i class="fas fa-paperclip mr-1"></i>
                                                                                Archivos adjuntos:
                                                                            </small>
                                                                            <div class="mt-2">
                                                                                <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <a href="<?php echo e(route('admin.gestiones.download-archivo', ['gestion' => $gestion->id, 'filename' => $file])); ?>" target="_blank" class="btn btn-sm btn-outline-primary mr-2 mb-1">
                                                                                        <i class="fas fa-download mr-1"></i>
                                                                                        <?php echo e($file); ?>

                                                                                    </a>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-center py-5">
                                                <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                                                <h6 class="text-muted">No hay gestiones registradas</h6>
                                                <p class="text-muted">Las acciones realizadas aparecerán aquí</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                
                                <?php if($solicitud->estado !== 'cerrada' && $solicitud->gestor_id === auth()->id()): ?>
                                <div class="card shadow-sm border-0">
                                    <div class="card-header bg-warning text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-plus-circle mr-2"></i>
                                            Agregar Nueva Acción
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <form action="<?php echo e(route('admin.solicitudes.gestion.store', $solicitud->id)); ?>" method="POST" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="from_modal" value="1">
                                            <div class="form-group">
                                                <label for="descripcion_modal_<?php echo e($solicitud->id); ?>" class="font-weight-bold">
                                                    <i class="fas fa-edit mr-1"></i>
                                                    Descripción de la Acción
                                                </label>
                                                <textarea name="descripcion" id="descripcion_modal_<?php echo e($solicitud->id); ?>" class="form-control" rows="3" 
                                                          placeholder="Describa la acción realizada..." required></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="archivos_gestion_modal_<?php echo e($solicitud->id); ?>" class="font-weight-bold">
                                                    <i class="fas fa-paperclip mr-1"></i>
                                                    Archivos Adjuntos (Opcional)
                                                </label>
                                                <input type="file" name="archivos_gestion[]" id="archivos_gestion_modal_<?php echo e($solicitud->id); ?>" 
                                                       class="form-control-file" multiple accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                                                <small class="form-text text-muted">
                                                    Formatos: PDF, DOC, DOCX, JPG, PNG. Máximo 5MB por archivo.
                                                </small>
                                            </div>
                                            <div class="text-right">
                                                <button type="submit" class="btn btn-success">
                                                    <i class="fas fa-save mr-2"></i>
                                                    Registrar Acción
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        
                        <div class="col-lg-4 bg-light">
                            <div class="p-4">
                                
                                <?php
                                    $evidenciasPath = storage_path('app/evidencias/' . $solicitud->id);
                                    $evidencias = [];
                                    if (is_dir($evidenciasPath)) {
                                        $files = scandir($evidenciasPath);
                                        foreach ($files as $file) {
                                            if ($file !== '.' && $file !== '..' && is_file($evidenciasPath . '/' . $file)) {
                                                $evidencias[] = [
                                                    'name' => $file,
                                                    'size' => filesize($evidenciasPath . '/' . $file),
                                                    'modified' => date('d/m/Y H:i', filemtime($evidenciasPath . '/' . $file)),
                                                    'download_url' => route('admin.solicitudes.download-evidencia', ['solicitud' => $solicitud->id, 'archivo' => $file])
                                                ];
                                            }
                                        }
                                    }
                                ?>

                                <?php if(count($evidencias) > 0): ?>
                                <div class="card shadow-sm border-0 mb-4">
                                    <div class="card-header bg-info text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-folder-open mr-2"></i>
                                            Evidencias
                                            <span class="badge badge-light ml-2"><?php echo e(count($evidencias)); ?></span>
                                        </h6>
                                    </div>
                                    <div class="card-body p-3">
                                        <div class="mb-3">
                                            <?php if(Route::has('admin.solicitudes.download-all-evidencias')): ?>
                                                <a href="<?php echo e(route('admin.solicitudes.download-all-evidencias', $solicitud->id)); ?>" 
                                                   class="btn btn-info btn-sm btn-block">
                                                    <i class="fas fa-download mr-2"></i>
                                                    Descargar Todo
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="evidence-list-modal">
                                            <?php $__currentLoopData = $evidencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evidencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="evidence-item-modal mb-3 p-2 bg-white rounded">
                                                    <div class="d-flex align-items-center mb-2">
                                                        <i class="fas fa-file-alt text-info mr-2"></i>
                                                        <span class="small text-truncate" title="<?php echo e($evidencia['name']); ?>">
                                                            <?php echo e($evidencia['name']); ?>

                                                        </span>
                                                    </div>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <small class="text-muted">
                                                            <?php echo e(number_format($evidencia['size'] / 1024, 1)); ?> KB
                                                        </small>
                                                        <?php if(Route::has('admin.solicitudes.download-evidencia')): ?>
                                                            <a href="<?php echo e($evidencia['download_url']); ?>" 
                                                               class="btn btn-outline-info btn-sm">
                                                                <i class="fas fa-download"></i>
                                                            </a>
                                                        <?php else: ?>
                                                            <span class="btn btn-outline-secondary btn-sm disabled">
                                                                <i class="fas fa-file"></i>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>

                                
                                <div class="card shadow-sm border-0">
                                    <div class="card-header bg-secondary text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-user mr-2"></i>
                                            Información de Contacto
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="contact-info-modal">
                                            <div class="mb-2">
                                                <small class="text-muted font-weight-bold">NOMBRE</small>
                                                <p class="mb-0"><?php echo e($solicitud->nombre ?? 'No especificado'); ?></p>
                                            </div>
                                            <div class="mb-2">
                                                <small class="text-muted font-weight-bold">EMAIL</small>
                                                <p class="mb-0">
                                                    <?php if($solicitud->email): ?>
                                                        <a href="mailto:<?php echo e($solicitud->email); ?>"><?php echo e($solicitud->email); ?></a>
                                                    <?php else: ?>
                                                        No especificado
                                                    <?php endif; ?>
                                                </p>
                                            </div>
                                            <div class="mb-0">
                                                <small class="text-muted font-weight-bold">TELÉFONO</small>
                                                <p class="mb-0"><?php echo e($solicitud->telefono ?? 'No especificado'); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer bg-light">
                <?php if($solicitud->estado !== 'cerrada' && $solicitud->gestor_id === auth()->id()): ?>
                    <button type="button" class="btn btn-warning cerrar-solicitud-btn" 
                            data-solicitud-id="<?php echo e($solicitud->id); ?>" 
                            data-solicitud-numero="#<?php echo e($solicitud->id); ?>">
                        <i class="fas fa-times mr-1"></i>Cerrar Solicitud
                    </button>
                <?php endif; ?>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-1"></i>Cerrar
                </button>
            </div>
        </div>
    </div>
</div>

<style>
/* Estilos específicos para el modal de gestión */
.modal-gestion-completa {
    z-index: 9999 !important;
}

.modal-gestion-completa .modal-backdrop {
    z-index: 9998 !important;
}

.modal-gestion-completa.show {
    z-index: 9999 !important;
}

.modal-gestion-completa .modal-dialog {
    z-index: 10000 !important;
    position: relative;
}

.modal-gestion-completa .modal-content {
    z-index: 10001 !important;
    position: relative;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3) !important;
}

/* Asegurar que el backdrop esté por debajo del modal */
.modal-backdrop.show {
    z-index: 9998 !important;
}

/* Estilos adicionales para mejorar la visibilidad */
.modal-gestion-completa .modal-header {
    border-bottom: 1px solid #dee2e6;
    position: relative;
    z-index: 10002;
}

.modal-gestion-completa .modal-footer {
    border-top: 1px solid #dee2e6;
    position: relative;
    z-index: 10002;
}

.modal-gestion-completa .modal-body {
    position: relative;
    z-index: 10001;
}

/* Corregir cualquier problema con elementos flotantes dentro del modal */
.modal-gestion-completa .btn-group,
.modal-gestion-completa .dropdown-menu,
.modal-gestion-completa .tooltip,
.modal-gestion-completa .popover {
    z-index: 10003 !important;
}

/* Asegurar que los botones de acción estén clickeables */
.modal-gestion-completa .modal-footer .btn,
.modal-gestion-completa .btn {
    position: relative;
    z-index: 10003;
    pointer-events: auto;
}

/* Corrección específica para AdminLTE si existe conflicto */
.wrapper .modal-gestion-completa {
    z-index: 9999 !important;
}

.info-item-modal label {
    color: #6c757d;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    text-transform: uppercase;
}

.timeline-container-modal {
    position: relative;
}

.timeline-container-modal::before {
    content: '';
    position: absolute;
    left: 12px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: linear-gradient(to bottom, #28a745, #e9ecef);
}

.timeline-item-modal {
    position: relative;
    padding-left: 40px;
}

.timeline-marker-modal {
    position: absolute;
    left: -8px;
    top: 8px;
    width: 16px;
    height: 16px;
    border-radius: 50%;
    border: 3px solid #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.evidence-item-modal {
    transition: all 0.2s ease;
    border: 1px solid transparent;
}

.evidence-item-modal:hover {
    border-color: #17a2b8;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

@media (max-width: 768px) {
    .timeline-item-modal {
        padding-left: 20px;
    }
    
    .timeline-container-modal::before {
        left: 4px;
    }
    
    .timeline-marker-modal {
        left: -4px;
        width: 12px;
        height: 12px;
    }
    
    .modal-gestion-completa .modal-dialog {
        margin: 0.5rem;
        max-width: calc(100% - 1rem);
    }
}
</style>
<?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/partials/modal-gestion-completa.blade.php ENDPATH**/ ?>