# SIAC - Sistema Integral de Atención Ciudadana

## Descripción General
SIAC es un sistema que permite a cualquier persona ingresar diferentes tipos de solicitudes de manera pública, proporcionando únicamente información de contacto y, de forma opcional, evidencia relacionada. Posteriormente, los administradores gestionan y responden estos requerimientos, cerrando cada caso una vez resuelto.

## Estructura de Carpetas
- `app/` - Lógica de la aplicación (modelos, controladores, proveedores)
- `bootstrap/` - Archivos de arranque de Laravel
- `config/` - Archivos de configuración
- `database/` - Migraciones, seeders y base de datos SQLite
- `public/` - Archivos públicos (index.php, assets, imágenes, CSS, JS)
- `resources/` - Vistas Blade, JS y CSS fuente, imágenes
- `routes/` - Definición de rutas (web.php, console.php)
- `storage/` - Archivos generados, logs, caché
- `tests/` - Pruebas unitarias y funcionales
- `vendor/` - Dependencias instaladas por Composer

## Librerías y Frameworks Utilizados
- Laravel (framework principal)
- AdminLTE (panel de administración)
- SweetAlert (notificaciones)
- Vite (compilación de assets)
- Bootstrap (estilos base)
- jQuery (interacciones JS)

## Módulos del Sistema
### 1. Nivel Cliente (Formulario Público)
- Acceso abierto para cualquier usuario.
- Permite ingresar solicitudes mediante un formulario simple.
- Validación de datos en frontend y backend.
- Confirmación visual de envío exitoso.

### 2. Nivel Gestión (Panel de Administración)
- Acceso restringido a usuarios autenticados (admin).
- Gestión de solicitudes: ver, filtrar, derivar, actualizar estado.
- Administración de organismos y tipos de solicitud.
- Visualización de estadísticas y reportes.

## Funcionalidades Destacadas
- Creación y gestión de tickets/solicitudes.
- Derivación automática o manual a organismos responsables.
- Panel de administración con AdminLTE.
- Sistema de autenticación y roles.

## Instalación y Uso
1. Clonar el repositorio y acceder a la carpeta del proyecto.
2. Instalar dependencias:
   ```bash
   composer install
   npm install && npm run build
   ```
3. Configurar el archivo `.env` y la base de datos (por defecto SQLite).
4. Ejecutar migraciones y seeders:
   ```bash
   php artisan migrate --seed
   ```
5. Levantar el servidor:
   ```bash
   php artisan serve
   ```
6. Acceder a:
   - Formulario público: `/`
   - Panel de gestión: `/login` (requiere usuario admin)

## Contacto y Soporte
Para dudas o soporte, contactar al equipo de desarrollo.
