<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TipoSolicitudController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $tipos = \App\Models\TipoSolicitud::all();
        return view('admin.tipo_solicitudes.index', compact('tipos'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.tipo_solicitudes.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'denominacion' => 'required|string|max:255',
            'descripcion' => 'nullable|string|max:1000',
            'activo' => 'required|boolean',
        ]);

        \App\Models\TipoSolicitud::create($validated);
        
        // Si es una petición AJAX, devolver JSON
        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Tipo de solicitud creado correctamente.'
            ]);
        }
        
        return redirect()->route('admin.tipo-solicitudes.index')->with('success', 'Tipo de solicitud creado correctamente.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $tipo = \App\Models\TipoSolicitud::findOrFail($id);
        return view('admin.tipo_solicitudes.edit', compact('tipo'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $validated = $request->validate([
            'denominacion' => 'required|string|max:255',
            'descripcion' => 'nullable|string|max:1000',
            'activo' => 'required|boolean',
        ]);

        $tipo = \App\Models\TipoSolicitud::findOrFail($id);
        $tipo->update($validated);
        
        // Si es una petición AJAX, devolver JSON
        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Tipo de solicitud actualizado correctamente.'
            ]);
        }
        
        return redirect()->route('admin.tipo-solicitudes.index')->with('success', 'Tipo de solicitud actualizado correctamente.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        try {
            $tipo = \App\Models\TipoSolicitud::findOrFail($id);
            
            // Verificar si tiene solicitudes asociadas
            if ($tipo->solicitudes()->count() > 0) {
                return redirect()->route('admin.tipo-solicitudes.index')
                    ->with('error', 'No se puede eliminar este tipo de solicitud porque tiene solicitudes asociadas.');
            }
            
            $tipo->delete();
            
            return redirect()->route('admin.tipo-solicitudes.index')
                ->with('success', 'Tipo de solicitud eliminado correctamente.');
                
        } catch (\Exception $e) {
            return redirect()->route('admin.tipo-solicitudes.index')
                ->with('error', 'Error al eliminar el tipo de solicitud: ' . $e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource via AJAX.
     */
    public function editAjax(string $id)
    {
        $tipo = \App\Models\TipoSolicitud::findOrFail($id);
        
        $content = view('admin.tipo_solicitudes.partials.edit-form', compact('tipo'))->render();
        
        return response()->json([
            'success' => true,
            'content' => $content,
            'title' => 'Editar Tipo de Solicitud'
        ]);
    }

    /**
     * Show the details of the specified resource via AJAX.
     */
    public function showAjax(string $id)
    {
        $tipo = \App\Models\TipoSolicitud::findOrFail($id);
        
        $content = view('admin.tipo_solicitudes.partials.show-details', compact('tipo'))->render();
        
        return response()->json([
            'success' => true,
            'content' => $content,
            'title' => 'Detalles del Tipo de Solicitud'
        ]);
    }
}
