<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class RegisterAdminController extends Controller
{
    public function showForm()
    {
        // Solo mostrar si no hay usuarios
        if (User::count() > 0) {
            return redirect('/login');
        }
        return view('auth.register_admin');
    }

    public function store(Request $request)
    {
        if (User::count() > 0) {
            return redirect('/login');
        }
        $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',
            'telefono' => 'nullable|string|max:30',
            'clave' => 'required|string',
            'password' => 'required|confirmed|min:6',
        ]);
        $claveEnv = env('CLAVE_REGISTRO_ADMIN');
        if (!$claveEnv || $request->clave !== $claveEnv) {
            return back()->withInput()->with('error', 'Clave de acceso incorrecta');
        }
        User::create([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'name' => $request->first_name . ' ' . $request->last_name,
            'email' => $request->email,
            'telefono' => $request->telefono,
            'role' => 'admin',
            'password' => Hash::make($request->password),
        ]);
        return redirect('/login')->with('success', 'Administrador creado correctamente. Ahora puede iniciar sesión.');
    }
}
