<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Organismo extends Model
{
    protected $fillable = [
        'nombre',
        'descripcion',
        'direccion',
        'telefono',
        'email',
        'parent_id',
    ];

    protected $table = 'organismos';

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'telefono' => 'string',
        'email' => 'string',
        'parent_id' => 'integer',
    ];

    public function solicitudes()
    {
        return $this->hasMany(Solicitud::class, 'organismo_requeridor_id');
    }

    // Relación padre
    public function parent()
    {
        return $this->belongsTo(Organismo::class, 'parent_id');
    }

    // Relación hijos
    public function children()
    {
        return $this->hasMany(Organismo::class, 'parent_id');
    }

    public static function boot()
    {
        parent::boot();

        static::saving(function ($organismo) {
            $maxNiveles = 4;
            $nivel = 1;
            $parent = $organismo->parent;
            while ($parent) {
                $nivel++;
                if ($nivel > $maxNiveles) {
                    throw new \Exception('No se pueden crear organismos con más de 4 niveles de anidamiento.');
                }
                $parent = $parent->parent;
            }
        });
    }
}
