<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Solicitud extends Model
{
    protected $fillable = [
        'tipo_solicitud_id',
        'organismo_requeridor_id',
        'notificacion',
        'detalle_solicitud',
        'fecha_solicitud',
        'observaciones',
        'estado',
        'uri_evidencia',
        // Datos de contacto
        'nombres',
        'apellido_paterno',
        'apellido_materno',
        'nacionalidad',
        'pais_residencia',
        'calle',
        'numero',
        'villa',
        'comuna',
        'telefono',
        'email',
        // Datos estadísticos
        'tipo_zona',
        'educacion',
        'edad',
        'ocupacion',
        'genero',
        'organizacion',
        'apoderado',
        'usuario_respuesta',
        // Gestión
        'gestor_id',
        'fecha_asignacion',
        'fecha_cierre',
        'tiempo_limite_horas',
        'observaciones_cierre',
    ];
    /**
     * Usuario gestor (moderador que gestiona la solicitud)
     */
    public function gestor()
    {
        return $this->belongsTo(User::class, 'gestor_id');
    }

    protected $table = 'solicitudes';
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'notificacion' => 'boolean',
        'fecha_solicitud' => 'date',
    ];

    public function gestiones()
    {
        return $this->hasMany(Gestion::class, 'solicitud_id');
    }

    public function tipoSolicitud()
    {
        return $this->belongsTo(TipoSolicitud::class, 'tipo_solicitud_id');
    }
    public function organismoRequeridor()
    {
        return $this->belongsTo(Organismo::class, 'organismo_requeridor_id');
    }
}
