<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('telefono')->nullable();
            $table->enum('role', ['admin', 'moderador', 'lectura'])->default('lectura');
            $table->foreignId('organismo_id')->nullable()->constrained('organismos');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['organismo_id']);
            $table->dropColumn(['first_name', 'last_name', 'telefono', 'role', 'organismo_id']);
        });
    }
};
