<?php

namespace Database\Seeders;

use App\Models\Organismo;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Desactivar claves foráneas (SQLite)
        DB::statement('PRAGMA foreign_keys = OFF;');

        // Vaciar tablas dependientes primero si es necesario
        // \App\Models\Solicitud::truncate(); // Descomenta si tienes solicitudes
        Organismo::truncate();
        // User::truncate(); // Eliminado para evitar error de Faker

        // Reactivar claves foráneas
        DB::statement('PRAGMA foreign_keys = ON;');

        // Insertar organismos base
        $organismos = [
            ['id' => 1, 'nombre' => 'CONCEJO MUNICIPAL', 'parent_id' => null],
            ['id' => 2, 'nombre' => 'COSOC', 'parent_id' => null],
            ['id' => 3, 'nombre' => 'CONSEJO DE SEGURIDAD PUBLICA', 'parent_id' => null],
            ['id' => 4, 'nombre' => 'ALCALDIA', 'parent_id' => null],
            ['id' => 5, 'nombre' => 'ADMINISTRACION', 'parent_id' => null],
            ['id' => 6, 'nombre' => 'JUZGADO DE POLICIA LOCAL', 'parent_id' => null],
            ['id' => 7, 'nombre' => 'DIRECCION DE OBRAS', 'parent_id' => null],
            ['id' => 8, 'nombre' => 'TRANSITO Y TRANSPORTE PUBLICO', 'parent_id' => null],
            ['id' => 9, 'nombre' => 'SECRETARIA MUNICIPAL', 'parent_id' => null],
            ['id' => 10, 'nombre' => 'CONTROL INTERNO', 'parent_id' => null],
            ['id' => 11, 'nombre' => 'SEGURIDAD PUBLICA', 'parent_id' => null],
            ['id' => 12, 'nombre' => 'ADMINISTRACION Y FINANZAS', 'parent_id' => null],
            ['id' => 13, 'nombre' => 'SECRETARIA COMUNAL DE PLANIFICACION', 'parent_id' => null],
            ['id' => 14, 'nombre' => 'DESARROLLO ECONOMICO LOCAL', 'parent_id' => null],
            ['id' => 15, 'nombre' => 'MEDIO AMBIENTE', 'parent_id' => null],
            ['id' => 16, 'nombre' => 'ASEO Y ORNATO', 'parent_id' => null],
            ['id' => 17, 'nombre' => 'DESARROLLO COMUNITARIO', 'parent_id' => null],
            // Hijos de ALCALDIA
            ['id' => 18, 'nombre' => 'GABINETE', 'parent_id' => 4],
            ['id' => 19, 'nombre' => 'COMUNICACIONES', 'parent_id' => 4],
            // Hijos de ADMINISTRACION
            ['id' => 20, 'nombre' => 'ASESORIA JURIDICA', 'parent_id' => 5],
            ['id' => 21, 'nombre' => 'DEPTO ELECTRICO', 'parent_id' => 5],
            ['id' => 22, 'nombre' => 'DEPTO PARQUE AUTOMOTRIZ', 'parent_id' => 5],
            ['id' => 23, 'nombre' => 'DEPTO DE OPERACIONES', 'parent_id' => 5],
            ['id' => 24, 'nombre' => 'DEPTO DE TI Y TRANSFORMACION DIGITAL', 'parent_id' => 5],
            // Hijos de DIRECCION DE OBRAS
            ['id' => 25, 'nombre' => 'FISCALIZACION', 'parent_id' => 7],
            ['id' => 26, 'nombre' => 'OBRAS VIALES Y FLUVIALES', 'parent_id' => 7],
            ['id' => 27, 'nombre' => 'CEMENTERIO', 'parent_id' => 7],
            // Hijos de TRANSITO Y TRANSPORTE PUBLICO
            ['id' => 28, 'nombre' => 'LICENCIAS DE CONDUCIR', 'parent_id' => 8],
            ['id' => 29, 'nombre' => 'PERMISOS DE CIRCULACION', 'parent_id' => 8],
            // Hijos de SECRETARIA MUNICIPAL
            ['id' => 30, 'nombre' => 'OIRS', 'parent_id' => 9],
            // Hijos de CONTROL INTERNO
            ['id' => 31, 'nombre' => 'AUDITORIAS', 'parent_id' => 10],
            // Hijos de SEGURIDAD PUBLICA
            ['id' => 32, 'nombre' => 'GESTION DE RIESGOS Y DESASTRES', 'parent_id' => 11],
            ['id' => 33, 'nombre' => 'FISCALIZACION', 'parent_id' => 11],
            ['id' => 34, 'nombre' => 'OFICINA PREVENCION DE DROGAS Y ALCOHOL', 'parent_id' => 11],
            // Hijos de ADMINISTRACION Y FINANZAS
            ['id' => 35, 'nombre' => 'PERSONAL, REMUNERACIONES Y BIENESTAR SOCIAL', 'parent_id' => 12],
            ['id' => 36, 'nombre' => 'CONTABILIDAD', 'parent_id' => 12],
            ['id' => 37, 'nombre' => 'TESORERIA', 'parent_id' => 12],
            ['id' => 38, 'nombre' => 'RENTAS Y PATENTES', 'parent_id' => 12],
            ['id' => 39, 'nombre' => 'ABASTECIMIENTO, BODEGA E INVENTARIO', 'parent_id' => 12],
            // Hijos de SECRETARIA COMUNAL DE PLANIFICACION
            ['id' => 40, 'nombre' => 'INVERSION COMUNITARIA', 'parent_id' => 13],
            ['id' => 41, 'nombre' => 'PROYECTOS DE INFRAESTRUCTURA Y EQUIPAMIENTO', 'parent_id' => 13],
            ['id' => 42, 'nombre' => 'AGUA POTABLE Y ELECTRIFICACION RURAL', 'parent_id' => 13],
            // Hijos de DESARROLLO ECONOMICO LOCAL
            ['id' => 43, 'nombre' => 'DESARROLLO RURAL', 'parent_id' => 14],
            ['id' => 44, 'nombre' => 'TURISMO', 'parent_id' => 14],
            ['id' => 45, 'nombre' => 'CENTRO DE EMPRENDIMIENTO', 'parent_id' => 14],
            ['id' => 46, 'nombre' => 'OMIL', 'parent_id' => 14],
            ['id' => 47, 'nombre' => 'ASUNTOS INDIGENAS', 'parent_id' => 14],
            // Hijos de DESARROLLO COMUNITARIO
            ['id' => 48, 'nombre' => 'DEPTO DE PROMOCION COMUNITARIA', 'parent_id' => 17],
            ['id' => 49, 'nombre' => 'DEPTO SOCIAL', 'parent_id' => 17],
            // Hijos de DEPTO DE TI Y TRANSFORMACION DIGITAL
            ['id' => 50, 'nombre' => 'TRANSPARENCIA', 'parent_id' => 24],
            ['id' => 51, 'nombre' => 'INFORMATICA', 'parent_id' => 24],
            // Hijos de DEPTO DE PROMOCION COMUNITARIA
            ['id' => 52, 'nombre' => 'ORGANIZACIONES COMUNITARIAS', 'parent_id' => 48],
            ['id' => 53, 'nombre' => 'PARTICIPACION CIUDADANA', 'parent_id' => 48],
            ['id' => 54, 'nombre' => 'OFICINA DE LA MUJER Y EQUIDAD', 'parent_id' => 48],
            ['id' => 55, 'nombre' => 'OFICINA DISCAPACIDAD', 'parent_id' => 48],
            ['id' => 56, 'nombre' => 'OFICINA NIÑEZ Y JUVENTUD', 'parent_id' => 48],
            ['id' => 57, 'nombre' => 'CULTURA', 'parent_id' => 48],
            ['id' => 58, 'nombre' => 'DEPORTES', 'parent_id' => 48],
            // Hijos de DEPTO SOCIAL
            ['id' => 59, 'nombre' => 'BENEFICIOS ECONOMICOS', 'parent_id' => 49],
            ['id' => 60, 'nombre' => 'AYUDAS SOCIALES', 'parent_id' => 49],
            ['id' => 61, 'nombre' => 'REGISTRO SOCIAL DE HOGARES', 'parent_id' => 49],
            ['id' => 62, 'nombre' => 'CASOS SOCIOSANITARIOS', 'parent_id' => 49],
            ['id' => 63, 'nombre' => 'VIVIENDA Y MEJORAMIENTO DE VIVIENDA', 'parent_id' => 49],
            ['id' => 64, 'nombre' => 'PROGRAMAS SOCIALES', 'parent_id' => 49],
            ['id' => 65, 'nombre' => 'PROGRAMA FAMILIAS - FOSIS', 'parent_id' => 49],
            ['id' => 66, 'nombre' => 'PROGRAMA VINCULOS', 'parent_id' => 49],
            ['id' => 67, 'nombre' => 'PERSONAS MAYORES ELEAM', 'parent_id' => 49],
            ['id' => 68, 'nombre' => 'PROGRAMA AUTOCONSUMO', 'parent_id' => 49],
            // Hijos de CULTURA
            ['id' => 69, 'nombre' => 'BIBLIOTECA', 'parent_id' => 57],
            ['id' => 70, 'nombre' => 'MUSEO MUNICIPAL', 'parent_id' => 57],
            // Hijos de DEPORTES
            ['id' => 71, 'nombre' => 'RECINTOS DEPORTIVOS', 'parent_id' => 58],
        ];
        foreach ($organismos as $org) {
            Organismo::create($org);
        }
    }
}
