// Script para manejar tablas responsivas del administrador
document.addEventListener('DOMContentLoaded', function() {
    
    // Función para detectar si una tabla necesita scroll horizontal
    function checkTableScroll() {
        const tables = document.querySelectorAll('.admin-responsive-table');
        
        tables.forEach(function(table) {
            if (table.scrollWidth > table.clientWidth) {
                table.classList.add('has-scroll');
                table.closest('.table-scroll-indicator')?.classList.add('table-scroll-indicator');
            } else {
                table.classList.remove('has-scroll');
                table.closest('.table-scroll-indicator')?.classList.remove('table-scroll-indicator');
            }
        });
    }
    
    // Función para convertir tablas existentes en responsivas
    function makeTablesResponsive() {
        const tables = document.querySelectorAll('table:not(.admin-responsive-table table)');
        
        tables.forEach(function(table) {
            // Solo convertir tablas que no estén ya dentro de un contenedor responsivo
            if (!table.closest('.admin-responsive-table')) {
                const wrapper = document.createElement('div');
                wrapper.className = 'admin-responsive-table table-scroll-indicator';
                
                // Insertar el wrapper antes de la tabla
                table.parentNode.insertBefore(wrapper, table);
                
                // Mover la tabla dentro del wrapper
                wrapper.appendChild(table);
            }
        });
    }
    
    // Ejecutar al cargar la página
    makeTablesResponsive();
    checkTableScroll();
    
    // Revisar en redimensionamiento de ventana
    window.addEventListener('resize', function() {
        setTimeout(checkTableScroll, 100);
    });
    
    // Revisar cuando se cargan nuevos contenidos (para AJAX)
    const observer = new MutationObserver(function(mutations) {
        let shouldCheck = false;
        
        mutations.forEach(function(mutation) {
            if (mutation.type === 'childList') {
                mutation.addedNodes.forEach(function(node) {
                    if (node.nodeType === 1 && (node.tagName === 'TABLE' || node.querySelector('table'))) {
                        shouldCheck = true;
                    }
                });
            }
        });
        
        if (shouldCheck) {
            setTimeout(function() {
                makeTablesResponsive();
                checkTableScroll();
            }, 100);
        }
    });
    
    // Observar cambios en el documento
    observer.observe(document.body, {
        childList: true,
        subtree: true
    });
    
    // Función para agregar indicadores de scroll en pantallas táctiles
    if ('ontouchstart' in window) {
        const responsiveTables = document.querySelectorAll('.admin-responsive-table');
        
        responsiveTables.forEach(function(table) {
            let isScrolling = false;
            
            table.addEventListener('scroll', function() {
                if (!isScrolling) {
                    table.style.boxShadow = 'inset 0 0 10px rgba(0,0,0,0.1)';
                    isScrolling = true;
                    
                    setTimeout(function() {
                        table.style.boxShadow = '';
                        isScrolling = false;
                    }, 1000);
                }
            });
        });
    }
});
