// public/js/organismos-create.js

document.addEventListener('DOMContentLoaded', function() {
    // Mensajes toast
    if (window.successMessage) {
        showToast({
            icon: 'success',
            title: window.successMessage
        });
    }
    if (window.errorMessage) {
        showToast({
            icon: 'error',
            title: 'Error',
            text: window.errorMessage,
            timer: 4000
        });
    }
    if (window.errorMessages) {
        showToast({
            icon: 'error',
            title: 'Errores en el formulario',
            html: window.errorMessages,
            timer: 4000
        });
    }
});

// Variable global para almacenar todos los organismos
let allOrganismos = [];

// Función para cargar organismos via AJAX
function loadOrganismos() {
    fetch('/admin/organismos/get-all-ajax')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                allOrganismos = data.organismos;
            }
        })
        .catch(error => console.error('Error cargando organismos:', error));
}

// Función para actualizar la jerarquía cuando se selecciona un nivel
function updateHierarchy(level) {
    const currentSelect = document.getElementById(`level${level}`);
    const selectedValue = currentSelect.value;
    const selectedName = currentSelect.options[currentSelect.selectedIndex]?.getAttribute('data-name') || '';
    
    // Limpiar niveles siguientes
    for (let i = level + 1; i <= 4; i++) {
        const nextSelect = document.getElementById(`level${i}`);
        nextSelect.innerHTML = '<option value="">Seleccionar...</option>';
        nextSelect.disabled = true;
        nextSelect.classList.add('disabled-select');
    }
    
    // Si se seleccionó algo, habilitar el siguiente nivel
    if (selectedValue && level < 4) {
        const nextLevel = level + 1;
        const nextSelect = document.getElementById(`level${nextLevel}`);
        
        // Cargar hijos del organismo seleccionado
        loadChildren(selectedValue, nextSelect);
        
        nextSelect.disabled = false;
        nextSelect.classList.remove('disabled-select');
    }
    
    // Actualizar el path y el parent_id
    updatePath();
    updateParentId();
}

// Función para cargar hijos de un organismo
function loadChildren(parentId, selectElement) {
    fetch(`/admin/organismos/${parentId}/children-ajax`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                selectElement.innerHTML = '<option value="">Crear como hijo directo</option>';
                data.children.forEach(child => {
                    const option = document.createElement('option');
                    option.value = child.id;
                    option.setAttribute('data-name', child.nombre);
                    option.textContent = child.nombre;
                    selectElement.appendChild(option);
                });
            }
        })
        .catch(error => console.error('Error cargando hijos:', error));
}

// Función para actualizar el path visual
function updatePath() {
    let path = [];
    let currentLevel = 1;
    
    while (currentLevel <= 4) {
        const select = document.getElementById(`level${currentLevel}`);
        const selectedOption = select.options[select.selectedIndex];
        
        if (select.value) {
            const name = selectedOption.getAttribute('data-name') || selectedOption.textContent;
            path.push(`Nivel ${currentLevel}: ${name}`);
            currentLevel++;
        } else {
            break;
        }
    }
    
    const pathText = document.getElementById('pathText');
    if (path.length === 0) {
        pathText.textContent = 'Nivel raíz (sin organismo padre)';
    } else {
        const nextLevel = path.length + 1;
        pathText.innerHTML = path.join(' → ') + ` → <strong>Nuevo organismo (Nivel ${nextLevel})</strong>`;
    }
}

// Función para actualizar el parent_id del formulario
function updateParentId() {
    let parentId = '';
    
    // Buscar el último nivel seleccionado
    for (let i = 4; i >= 1; i--) {
        const select = document.getElementById(`level${i}`);
        if (select.value) {
            parentId = select.value;
            break;
        }
    }
    
    document.getElementById('selectedParentId').value = parentId;
}

// Inicializar la carga de organismos al cargar la página
document.addEventListener('DOMContentLoaded', function() {
    loadOrganismos();
    updatePath(); // Mostrar path inicial
});
