// Script para asegurar el correcto funcionamiento del sidebar del admin
(function() {
    'use strict';
    
    // Función para asegurar que el sidebar sea clickeable
    function ensureSidebarClickable() {
        const sidebar = document.querySelector('.main-sidebar');
        if (sidebar) {
            sidebar.style.pointerEvents = 'auto';
            
            // Asegurar que todos los enlaces del sidebar sean clickeables
            const links = sidebar.querySelectorAll('a, .nav-link');
            links.forEach(link => {
                link.style.pointerEvents = 'auto';
                link.style.position = 'relative';
                link.style.zIndex = '2';
            });
        }
    }
    
    // Ejecutar cuando el DOM esté listo
    document.addEventListener('DOMContentLoaded', function() {
        ensureSidebarClickable();
        
        // Verificar periódicamente por si algo interfiere
        setInterval(ensureSidebarClickable, 1000);
        
        // Escuchar eventos de modales
        document.addEventListener('show.bs.modal', function() {
            setTimeout(ensureSidebarClickable, 100);
        });
        
        document.addEventListener('shown.bs.modal', function() {
            setTimeout(ensureSidebarClickable, 100);
        });
        
        document.addEventListener('hidden.bs.modal', function() {
            setTimeout(ensureSidebarClickable, 100);
        });
    });
    
    // También ejecutar cuando la página esté completamente cargada
    window.addEventListener('load', ensureSidebarClickable);
})();
