function showToast(options) {
    console.log('showToast called with options:', options);
    
    if (typeof Swal === 'undefined') {
        console.error('SweetAlert2 is not loaded!');
        return;
    }
    
    // Si tiene html o title, no usar toast, usar modal normal
    if (options.html || options.title) {
        Swal.fire({
            icon: options.icon || 'info',
            title: options.title || 'Información',
            html: options.html,
            text: options.text,
            showConfirmButton: true,
            confirmButtonText: 'Entendido',
            confirmButtonColor: '#007bff',
            timer: options.timer,
            timerProgressBar: !!options.timer,
            ...options
        });
    } else {
        // Usar toast normal
        Swal.fire({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: options.timer || 3500,
            timerProgressBar: true,
            icon: options.icon || 'info',
            text: options.text,
            ...options
        });
    }
}
