/**
 * JavaScript para la gestión de usuarios en el admin
 */

document.addEventListener('DOMContentLoaded', function() {
    initializeUsersPage();
});

/**
 * Inicializa la página de usuarios
 */
function initializeUsersPage() {
    initializeDeleteConfirmations();
    formatRoleBadges();
    handleEmptyOrganism();
}

/**
 * Inicializa las confirmaciones de eliminación
 */
function initializeDeleteConfirmations() {
    const deleteButtons = document.querySelectorAll('.btn-delete');
    
    deleteButtons.forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            
            const form = this.closest('form');
            const userName = this.closest('tr').querySelector('td:nth-child(2)').textContent + ' ' + 
                           this.closest('tr').querySelector('td:nth-child(3)').textContent;
            
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    title: '¿Eliminar usuario?',
                    text: `¿Estás seguro de eliminar al usuario "${userName.trim()}"? Esta acción no se puede deshacer.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Sí, eliminar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            } else {
                if (confirm(`¿Estás seguro de eliminar al usuario "${userName.trim()}"?`)) {
                    form.submit();
                }
            }
        });
    });
}

/**
 * Formatea los badges de roles
 */
function formatRoleBadges() {
    const roleCells = document.querySelectorAll('td:nth-child(6)');
    
    roleCells.forEach(cell => {
        const roleText = cell.textContent.trim().toLowerCase();
        const badge = document.createElement('span');
        badge.className = `role-badge role-${roleText}`;
        badge.textContent = cell.textContent.trim();
        
        cell.innerHTML = '';
        cell.appendChild(badge);
    });
}

/**
 * Maneja la visualización de organismos vacíos
 */
function handleEmptyOrganism() {
    const organismCells = document.querySelectorAll('td:nth-child(7)');
    
    organismCells.forEach(cell => {
        if (cell.textContent.trim() === '-' || cell.textContent.trim() === '') {
            cell.innerHTML = '<span class="no-organismo">Sin asignar</span>';
        }
    });
}

/**
 * Función para mostrar notificaciones de éxito
 * @param {string} message - Mensaje a mostrar
 */
function showSuccessMessage(message) {
    if (typeof showToast === 'function') {
        showToast({
            text: message,
            icon: 'success',
            timer: 4000
        });
    }
}

/**
 * Función para mostrar notificaciones de error
 * @param {string} message - Mensaje a mostrar
 */
function showErrorMessage(message) {
    if (typeof showToast === 'function') {
        showToast({
            text: message,
            icon: 'error',
            timer: 5000
        });
    }
}
