// resources/js/tipo-solicitudes.js

document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, checking for messages...');
    // Variables para mensajes
    if (window.successMessage) {
        console.log('Success message found:', window.successMessage);
        showToast({
            icon: 'success',
            title: window.successMessage
        });
    } else {
        console.log('No success message');
    }

    if (window.errorMessage) {
        console.log('Error message found:', window.errorMessage);
        showToast({
            icon: 'error',
            title: 'Error',
            text: window.errorMessage,
            timer: 4000
        });
    } else {
        console.log('No error message');
    }

    if (window.errorMessages) {
        console.log('Error messages found:', window.errorMessages);
        showToast({
            icon: 'error',
            title: 'Errores en el formulario',
            html: window.errorMessages,
            timer: 4000
        });
    } else {
        console.log('No error messages');
    }

    // Confirmación SweetAlert para eliminar tipo de solicitud
    document.querySelectorAll('.delete-tipo-form').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            Swal.fire({
                title: '¿Estás seguro?',
                text: 'Esta acción no se puede deshacer.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
});

// Función para cargar modal de edición
function loadEditModal(id) {
    fetch(`${window.tipoSolicitudesIndexRoute}/${id}/edit-ajax`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                openEditModal(
                    data.title,
                    data.content,
                    `${window.tipoSolicitudesIndexRoute}/${id}`,
                    'PUT'
                );
            }
        })
        .catch(error => console.error('Error:', error));
}

// Función para cargar modal de detalles
function loadViewModal(id) {
    fetch(`${window.tipoSolicitudesIndexRoute}/${id}/show-ajax`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                openViewModal(data.title, data.content);
            }
        })
        .catch(error => console.error('Error:', error));
}
