<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Panel de Administración') - SIAC</title>
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/adminlte.min.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/plugins/fontawesome-free/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/admin-tables-responsive.css') }}">
    <link rel="stylesheet" href="{{ asset('css/sidebar-mobile-fix.css') }}">
    @stack('styles')
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <!-- Left navbar links -->
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#" role="button" id="sidebar-toggle">
                    <i class="fas fa-bars"></i>
                </a>
            </li>
            <li class="nav-item d-none d-sm-inline-block">
                <a href="/admin" class="nav-link">Dashboard</a>
            </li>
        </ul>

        <!-- Right navbar links -->
        <ul class="navbar-nav ml-auto">
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-user-circle"></i>
                    <span class="d-none d-md-inline">{{ auth()->user()->name ?? 'Usuario' }}</span>
                </a>
                <div class="dropdown-menu dropdown-menu-right">
                    <a class="dropdown-item" href="#">
                        <i class="fas fa-user mr-2"></i> Perfil
                    </a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="{{ route('logout') }}" 
                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt mr-2"></i> Cerrar Sesión
                    </a>
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </div>
            </li>
        </ul>
    </nav>

    @include('admin.partials.sidebar')
    <div class="content-wrapper">
        <section class="content pt-4">
            <div class="container-fluid">
                @yield('content')
            </div>
        </section>
    </div>
    
    <!-- Mobile sidebar overlay -->
    <div class="sidebar-overlay" id="sidebar-overlay"></div>
</div>
<script src="{{ asset('vendor/adminlte/plugins/jquery/jquery.min.js') }}"></script>
<script src="{{ asset('vendor/adminlte/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('vendor/adminlte/dist/js/adminlte.min.js') }}"></script>
<script src="{{ asset('js/admin-tables-responsive.js') }}"></script>
<script src="{{ asset('js/sidebar-fix.js') }}"></script>
@stack('scripts')

<!-- Script personalizado para sidebar responsive -->
<script>
$(document).ready(function() {
    let sidebarOpen = false;
    
    // Función para detectar si estamos en móvil
    function isMobile() {
        return $(window).width() < 992;
    }
    
    // FORZAR CURSOR POINTER - MÉTODO AGRESIVO
    function forcePointerCursor() {
        const style = document.createElement('style');
        style.innerHTML = `
            .main-sidebar a,
            .main-sidebar .nav-link,
            .sidebar a,
            .sidebar .nav-link,
            .main-sidebar .nav-icon,
            .main-sidebar p,
            .sidebar .nav-icon,
            .sidebar p {
                cursor: pointer !important;
                pointer-events: auto !important;
            }
            .main-sidebar,
            .sidebar {
                pointer-events: auto !important;
            }
        `;
        document.head.appendChild(style);
        
        // También aplicar directamente a los elementos
        $('.main-sidebar, .sidebar').find('a, .nav-link, .nav-icon, p').each(function() {
            this.style.setProperty('cursor', 'pointer', 'important');
            this.style.setProperty('pointer-events', 'auto', 'important');
        });
    }
    
    // Ejecutar inmediatamente
    forcePointerCursor();
    
    // Función para toggle sidebar en móviles
    function toggleMobileSidebar() {
        if (isMobile()) {
            sidebarOpen = !sidebarOpen;
            if (sidebarOpen) {
                $('body').addClass('sidebar-open');
                $('#sidebar-overlay').show().css('opacity', '1');
            } else {
                $('body').removeClass('sidebar-open');
                $('#sidebar-overlay').hide();
            }
        }
    }
    
    // Manejar click en botón hamburguesa
    $(document).on('click', '#sidebar-toggle', function(e) {
        if (isMobile()) {
            e.preventDefault();
            e.stopPropagation();
            toggleMobileSidebar();
            return false;
        }
    });
    
    // Interceptar el data-widget de AdminLTE en móviles
    $(document).on('click', '[data-widget="pushmenu"]', function(e) {
        if (isMobile()) {
            e.preventDefault();
            e.stopPropagation();
            toggleMobileSidebar();
            return false;
        }
    });
    
    // Cerrar sidebar al hacer click en overlay
    $(document).on('click', '#sidebar-overlay', function() {
        if (isMobile() && sidebarOpen) {
            sidebarOpen = false;
            $('body').removeClass('sidebar-open');
            $(this).hide();
        }
    });
    
    // Manejar clicks en enlaces del sidebar
    $(document).on('click', '.main-sidebar a[href]:not([href="#"]), .sidebar a[href]:not([href="#"])', function(e) {
        const href = $(this).attr('href');
        
        if (href && href !== '#' && href !== 'javascript:void(0)') {
            // Prevenir comportamiento por defecto solo si necesitamos cerrar sidebar
            if (isMobile() && sidebarOpen) {
                e.preventDefault();
                sidebarOpen = false;
                $('body').removeClass('sidebar-open');
                $('#sidebar-overlay').hide();
                
                // Navegar después de cerrar sidebar
                setTimeout(() => {
                    window.location.href = href;
                }, 200);
            }
            // Si no es móvil o sidebar no está abierto, dejar navegación normal
        }
    });
    
    // Manejar treeview (menús desplegables)
    $(document).on('click', '.nav-item.has-treeview > .nav-link[href="#"]', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const $parent = $(this).closest('.nav-item');
        const $treeview = $parent.find('.nav-treeview');
        
        if ($parent.hasClass('menu-open')) {
            $parent.removeClass('menu-open');
            $treeview.slideUp(250);
        } else {
            // Cerrar otros treeviews
            $('.nav-item.has-treeview.menu-open').not($parent).each(function() {
                $(this).removeClass('menu-open');
                $(this).find('.nav-treeview').slideUp(250);
            });
            
            $parent.addClass('menu-open');
            $treeview.slideDown(250);
        }
    });
    
    // Re-aplicar estilos cuando cambie el tamaño de ventana
    $(window).on('resize', function() {
        if (!isMobile()) {
            $('body').removeClass('sidebar-open');
            $('#sidebar-overlay').hide();
            sidebarOpen = false;
        }
        
        // Re-forzar cursor
        setTimeout(forcePointerCursor, 100);
    });
    
    // Re-aplicar estilos periódicamente para combatir AdminLTE
    setInterval(forcePointerCursor, 1000);
    
    // Configuración inicial
    if (isMobile()) {
        $('body').removeClass('sidebar-open');
        $('#sidebar-overlay').hide();
        sidebarOpen = false;
    }
    
    // Debug: mostrar cuando se hace click
    $('.main-sidebar, .sidebar').on('click', function(e) {
        console.log('Click en sidebar:', e.target);
    });
});
</script>
</body>
</html>
