@extends('layouts.admin')

@section('title', 'Crear Organismo')

@push('styles')
    @vite(['resources/css/admin-organismos-form.css'])
@endpush

@section('content')

    <h2 class="text-gray font-weight-bold mb-4" >Nuevo Organismo</h2>
    <x-validation-errors />
    
    <div class="hierarchy-selector">
        <h5 class="text-muted mb-3"><i class="fas fa-sitemap"></i> Ubicación en el Organigrama</h5>

        <div class="row">
            <div class="col-md-3">
                <div class="level-selector">
                    <div class="level-indicator">Nivel 1 (Raíz)</div>
                    <select id="level1" class="form-control">
                        <option value="">Crear en nivel raíz</option>
                        @foreach($organismos->whereNull('parent_id') as $org)
                            <option value="{{ $org->id }}" data-name="{{ $org->nombre }}">{{ $org->nombre }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="level-selector">
                    <div class="level-indicator">Nivel 2</div>
                    <select id="level2" class="form-control disabled-select" disabled>
                        <option value="">Seleccionar...</option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="level-selector">
                    <div class="level-indicator">Nivel 3</div>
                    <select id="level3" class="form-control disabled-select" disabled>
                        <option value="">Seleccionar...</option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="level-selector">
                    <div class="level-indicator">Nivel 4</div>
                    <select id="level4" class="form-control disabled-select" disabled>
                        <option value="">Seleccionar...</option>
                    </select>
                </div>
            </div>
        </div>
        
        <div class="hierarchy-path" id="hierarchyPath">
            <strong>Ubicación:</strong> <span id="pathText">Nivel raíz (sin organismo padre)</span>
        </div>
    </div>

    <form action="{{ route('admin.organismos.store') }}" method="POST" id="organismoForm">
        @csrf
        <input type="hidden" name="parent_id" id="selectedParentId" value="">
        
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre *</label>
            <input type="text" name="nombre" id="nombre" class="form-control" value="{{ old('nombre') }}" required>
        </div>
        
        <div class="mb-3">
            <label for="descripcion" class="form-label">Descripción</label>
            <textarea name="descripcion" id="descripcion" class="form-control" rows="3">{{ old('descripcion') }}</textarea>
        </div>
        
        <div class="mb-3">
            <label for="direccion" class="form-label">Dirección</label>
            <input type="text" name="direccion" id="direccion" class="form-control" value="{{ old('direccion') }}">
        </div>
        
        <div class="mb-3">
            <label for="telefono" class="form-label">Teléfono</label>
            <input type="text" name="telefono" id="telefono" class="form-control" value="{{ old('telefono') }}">
        </div>
        
        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}">
        </div>
        
        <button type="submit" class="btn btn-primary">Guardar</button>
        <a href="{{ route('admin.organismos.index') }}" class="btn btn-secondary">Volver</a>
    </form>
@endsection

@push('scripts')
    @vite(['resources/js/admin-organismos-form.js'])
    <script>
        // Variables globales para el contexto
        window.successMessage = @json(session('success'));
        window.errorMessage = @json(session('error'));
        window.errorMessages = @json($errors->any() ? implode('<br>', $errors->all()) : null);
    </script>
@endpush
