{{-- Vista de detalles para el modal --}}
<div class="row">
    <div class="col-md-6">
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-primary text-white">
                <i class="fas fa-building"></i> Identidad del Organismo
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <span class="fw-bold">ID:</span>
                    <span class="ms-2">{{ $organismo->id }}</span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Nombre:</span>
                    <span class="ms-2">{{ $organismo->nombre }}</span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Descripción:</span>
                    <span class="ms-2">{{ $organismo->descripcion ?: 'Sin descripción' }}</span>
                </div>
            </div>
        </div>
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-info text-white">
                <i class="fas fa-map-marker-alt"></i> Información de Contacto
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <span class="fw-bold">Dirección:</span>
                    <span class="ms-2">{{ $organismo->direccion ?: 'Sin dirección' }}</span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Teléfono:</span>
                    <span class="ms-2">{{ $organismo->telefono ?: 'Sin teléfono' }}</span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Email:</span>
                    <span class="ms-2">{{ $organismo->email ?: 'Sin email' }}</span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-secondary text-white">
                <i class="fas fa-sitemap"></i> Jerarquía
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <span class="fw-bold">Organismo Padre:</span>
                    <span class="ms-2">
                        @if($organismo->parent)
                            {{ $organismo->parent->nombre }}
                        @else
                            Sin organismo padre
                        @endif
                    </span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Organismos hijos:</span>
                    <span class="ms-2">{{ $organismo->children()->count() }} organismo(s)</span>
                </div>
            </div>
        </div>
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-light text-dark">
                <i class="fas fa-calendar-alt"></i> Fechas
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <span class="fw-bold">Creado:</span>
                    <span class="ms-2">{{ $organismo->created_at->format('d/m/Y H:i') }}</span>
                </div>
                <div class="mb-2">
                    <span class="fw-bold">Actualizado:</span>
                    <span class="ms-2">{{ $organismo->updated_at->format('d/m/Y H:i') }}</span>
                </div>
            </div>
        </div>
        <div class="card mb-3 shadow-sm">
            <div class="card-header bg-success text-white">
                <i class="fas fa-tasks"></i> Solicitudes Asociadas
            </div>
            <div class="card-body">
                <span>{{ $organismo->solicitudes()->count() }} solicitud(es)</span>
            </div>
        </div>
    </div>
</div>
