@php
    $isMantenedoresOpen = request()->is('admin/tipo-solicitudes*') || request()->is('admin/organismos*') || request()->is('admin/users*');
    $user = auth()->user();
@endphp

<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="/admin" class="brand-link">
        <img src="{{ asset('images/logo.png') }}" alt="Logo SIAC" class="brand-image img-circle elevation-3" style="width: 33px; height: 33px; object-fit: cover; opacity: .9;">
        <span class="brand-text font-weight-light">SIAC Admin</span>
    </a>
    
    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="/admin" class="nav-link{{ request()->is('admin') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-tachometer-alt text-info"></i>
                        <p>Dashboard</p>
                    </a>
                </li>
                
                @if($user && $user->role === 'admin')
                <li class="nav-item has-treeview{{ $isMantenedoresOpen ? ' menu-open' : '' }}">
                    <a href="#" class="nav-link{{ $isMantenedoresOpen ? ' active' : '' }}">
                        <i class="nav-icon fas fa-cogs text-warning"></i>
                        <p>
                            Mantenedores
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="{{ $isMantenedoresOpen ? 'display:block;' : 'display:none;' }}">
                        <li class="nav-item">
                            <a href="{{ route('admin.tipo-solicitudes.index') }}" class="nav-link{{ request()->is('admin/tipo-solicitudes*') ? ' active' : '' }}">
                                <i class="far fa-circle nav-icon text-primary"></i>
                                <p>Tipos de Solicitud</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.organismos.index') }}" class="nav-link{{ request()->is('admin/organismos*') ? ' active' : '' }}">
                                <i class="far fa-circle nav-icon text-success"></i>
                                <p>Organismos</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.users.index') }}" class="nav-link{{ request()->is('admin/users*') ? ' active' : '' }}">
                                <i class="far fa-circle nav-icon text-danger"></i>
                                <p>Usuarios</p>
                            </a>
                        </li>
                    </ul>
                </li>
                @endif
                
                @if($user && ($user->role === 'admin' || $user->role === 'moderador'))
                <li class="nav-item">
                    <a href="{{ route('admin.solicitudes.index') }}" class="nav-link{{ request()->is('admin/solicitudes*') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-inbox text-primary"></i>
                        <p>Solicitudes</p>
                    </a>
                </li>
                @endif
            </ul>
        </nav>
    </div>
</aside>
