{{-- Información de Contacto --}}
@if($solicitud->nombres || $solicitud->email || $solicitud->telefono)
<div class="card shadow-sm border-0 mt-3">
    <div class="card-header bg-secondary text-white">
        <h6 class="mb-0"><i class="fas fa-address-card mr-2"></i>Contacto</h6>
    </div>
    <div class="card-body p-2">
        @if($solicitud->nombres)
        <div class="mb-2">
            <small class="text-muted">Nombre:</small><br>
            <span class="small">{{ $solicitud->nombres }} {{ $solicitud->apellido_paterno }} {{ $solicitud->apellido_materno }}</span>
        </div>
        @endif
        @if($solicitud->email)
        <div class="mb-2">
            <small class="text-muted">Email:</small><br>
            <a href="mailto:{{ $solicitud->email }}" class="small text-primary">{{ $solicitud->email }}</a>
        </div>
        @endif
        @if($solicitud->telefono)
        <div class="mb-2">
            <small class="text-muted">Teléfono:</small><br>
            <a href="tel:{{ $solicitud->telefono }}" class="small text-primary">{{ $solicitud->telefono }}</a>
        </div>
        @endif
    </div>
</div>
@endif
