{{-- Panel de Evidencias --}}
<div class="card shadow-sm border-0">
    <div class="card-header bg-info text-white">
        <h6 class="mb-0"><i class="fas fa-paperclip mr-2"></i>Evidencias</h6>
    </div>
    <div class="card-body p-2">
        @php
            $evidencias = [];
            if($solicitud->uri_evidencia && file_exists($solicitud->uri_evidencia)) {
                $evidenciaPath = $solicitud->uri_evidencia;
                if (is_dir($evidenciaPath)) {
                    $scanFiles = scandir($evidenciaPath);
                    foreach ($scanFiles as $file) {
                        if ($file !== '.' && $file !== '..' && is_file($evidenciaPath . '/' . $file)) {
                            $fullPath = $evidenciaPath . '/' . $file;
                            $evidencias[] = [
                                'name' => $file,
                                'size' => filesize($fullPath),
                                'extension' => strtolower(pathinfo($file, PATHINFO_EXTENSION)),
                                'download_url' => route('admin.solicitudes.download-evidencia', [
                                    'id' => $solicitud->id,
                                    'filename' => $file
                                ])
                            ];
                        }
                    }
                }
            }
        @endphp

        @if(count($evidencias) > 0)
            <div class="evidencias-list">
                @foreach($evidencias as $evidencia)
                <div class="evidencia-item mb-2 p-2 border rounded bg-white">
                    <div class="d-flex align-items-center">
                        <div class="evidencia-icon mr-2">
                            @if(in_array($evidencia['extension'], ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']))
                                <i class="fas fa-file-image text-success"></i>
                            @elseif(in_array($evidencia['extension'], ['pdf']))
                                <i class="fas fa-file-pdf text-danger"></i>
                            @elseif(in_array($evidencia['extension'], ['doc', 'docx']))
                                <i class="fas fa-file-word text-primary"></i>
                            @elseif(in_array($evidencia['extension'], ['xls', 'xlsx']))
                                <i class="fas fa-file-excel text-success"></i>
                            @elseif(in_array($evidencia['extension'], ['txt']))
                                <i class="fas fa-file-alt text-muted"></i>
                            @else
                                <i class="fas fa-file text-muted"></i>
                            @endif
                        </div>
                        <div class="evidencia-info flex-grow-1">
                            <div class="evidencia-name small font-weight-bold" title="{{ $evidencia['name'] }}">
                                {{ Str::limit($evidencia['name'], 25) }}
                            </div>
                            <div class="evidencia-meta text-muted" style="font-size: 0.75rem;">
                                {{ number_format($evidencia['size'] / 1024, 1) }} KB
                            </div>
                        </div>
                    </div>
                    <div class="evidencia-actions mt-2">
                        <a href="{{ $evidencia['download_url'] }}" 
                           class="btn btn-sm btn-outline-primary btn-block" 
                           title="Descargar {{ $evidencia['name'] }}">
                            <i class="fas fa-download mr-1"></i>Descargar
                        </a>
                        @if(in_array($evidencia['extension'], ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']))
                        <button type="button" 
                                class="btn btn-sm btn-outline-info btn-block mt-1"
                                onclick="previewImage('{{ $evidencia['download_url'] }}', '{{ $evidencia['name'] }}')"
                                title="Vista previa">
                            <i class="fas fa-eye mr-1"></i>Vista previa
                        </button>
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
        @else
            <div class="text-center text-muted py-4">
                <i class="fas fa-folder-open fa-2x mb-2"></i>
                <div>No hay evidencias adjuntas</div>
            </div>
        @endif
    </div>
</div>
