{{-- Acciones del pie del modal --}}
@if(!$solicitud->gestor_id)
    <form action="{{ route('admin.solicitudes.gestionar', $solicitud->id) }}" method="POST" style="display:inline-block;">
        @csrf
        <button type="submit" class="btn btn-success mr-2">
            <i class="fas fa-play mr-1"></i>Comenzar Gestión
        </button>
    </form>
@else
    <a href="{{ route('admin.solicitudes.show', $solicitud->id) }}" class="btn btn-info mr-2">
        <i class="fas fa-tasks mr-1"></i>Ver Gestión Completa
    </a>
    @if($solicitud->estado !== 'cerrada' && $solicitud->gestor_id === auth()->id())
        <button type="button" class="btn btn-warning mr-2 cerrar-solicitud-btn" 
                data-solicitud-id="{{ $solicitud->id }}" 
                data-solicitud-numero="#{{ $solicitud->id }}">
            <i class="fas fa-times mr-1"></i>Cerrar Solicitud
        </button>
    @elseif($solicitud->estado !== 'cerrada')
        <div class="alert alert-info mb-0 mr-2">
            <i class="fas fa-info-circle mr-1"></i>
            Solo <strong>{{ $solicitud->gestor->name }}</strong> puede cerrar esta solicitud
        </div>
    @endif
@endif
<button type="button" class="btn btn-secondary" data-dismiss="modal">
    <i class="fas fa-times mr-1"></i>Cerrar
</button>
