{{-- Historial de Gestiones --}}
@if($solicitud->gestiones && $solicitud->gestiones->count())
<div class="card shadow-sm border-0">
    <div class="card-header bg-light">
        <h6 class="mb-0 text-primary"><i class="fas fa-tasks mr-2"></i>Historial de Gestiones</h6>
    </div>
    <div class="card-body">
        <div class="timeline">
            @foreach($solicitud->gestiones->sortBy('fecha_gestion') as $gestion)
            <div class="timeline-item mb-3">
                <div class="timeline-marker bg-primary"></div>
                <div class="timeline-content">
                    <div class="d-flex justify-content-between align-items-start mb-1">
                        <span class="badge badge-light">{{ \Carbon\Carbon::parse($gestion->fecha_gestion)->format('d/m/Y H:i') }}</span>
                    </div>
                    <div class="bg-light p-2 rounded">
                        {{ $gestion->descripcion_gestion ?? 'Sin descripción' }}
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endif
