{{-- Observaciones de Cierre --}}
@if($solicitud->estado === 'cerrada' && $solicitud->observaciones_cierre)
<div class="card shadow-sm border-0 mb-4">
    <div class="card-header bg-light">
        <h6 class="mb-0 text-success"><i class="fas fa-check-circle mr-2"></i>Observaciones de Cierre</h6>
    </div>
    <div class="card-body">
        <div class="border-left border-success pl-3">
            <div class="text-muted small mb-2">
                <i class="fas fa-calendar-alt mr-1"></i>
                Cerrada el {{ \Carbon\Carbon::parse($solicitud->fecha_cierre)->format('d/m/Y \a \l\a\s H:i') }}
                por <strong>{{ $solicitud->gestor->name ?? 'Usuario desconocido' }}</strong>
            </div>
            <div class="font-weight-normal">
                {{ $solicitud->observaciones_cierre }}
            </div>
        </div>
    </div>
</div>
@endif
