@extends('layouts.admin')

@section('content')
<div class="card card-primary card-outline mt-4">
    <div class="card-header">
        <h3 class="card-title">Gestión de Solicitud #{{ $solicitud->id }}</h3>
    </div>
    <div class="card-body">
        <div class="row mb-3">
            <div class="col-md-6">
                <strong>Tipo:</strong> {{ $solicitud->tipoSolicitud->denominacion ?? '-' }}<br>
                <strong>Organismo:</strong> {{ $solicitud->organismoRequeridor->nombre ?? '-' }}<br>
                <strong>Estado:</strong> {{ ucfirst($solicitud->estado) }}<br>
                <strong>Fecha:</strong> {{ $solicitud->fecha_solicitud }}<br>
                <strong>Gestor:</strong> {{ $solicitud->gestor?->name ?? '-' }}<br>
            </div>
            <div class="col-md-6">
                <strong>Detalle:</strong><br>
                <span>{{ $solicitud->detalle_solicitud }}</span>
            </div>
        </div>
        
        <!-- Sección de Evidencias -->
        @if(count($evidencias) > 0)
        <hr>
        <h5>Archivos de Evidencia ({{ count($evidencias) }})</h5>
        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="text-muted">Archivos adjuntados por el solicitante</span>
                            <a href="{{ route('admin.solicitudes.download-all-evidencias', $solicitud->id) }}" 
                               class="btn btn-primary btn-sm">
                                <i class="fas fa-download"></i> Descargar Todo (ZIP)
                            </a>
                        </div>
                        
                        <div class="admin-responsive-table table-scroll-indicator">
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th class="expandable-cell">Archivo</th>
                                        <th>Tamaño</th>
                                        <th>Fecha Modificación</th>
                                        <th width="100" class="actions-cell">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($evidencias as $evidencia)
                                    <tr>
                                        <td>
                                            <i class="fas fa-file-alt text-secondary me-2"></i>
                                            {{ $evidencia['name'] }}
                                        </td>
                                        <td>{{ number_format($evidencia['size'] / 1024, 1) }} KB</td>
                                        <td>{{ $evidencia['modified'] }}</td>
                                        <td>
                                            <a href="{{ $evidencia['download_url'] }}" 
                                               class="btn btn-outline-primary btn-sm" 
                                               title="Descargar archivo">
                                                <i class="fas fa-download"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
        <hr>
        <h5>Acciones Realizadas</h5>
        @if($solicitud->gestiones && $solicitud->gestiones->count())
            <ul class="list-group mb-3">
                @foreach($solicitud->gestiones as $gestion)
                    <li class="list-group-item">
                        <strong>{{ $gestion->created_at->format('d/m/Y H:i') }}:</strong> {{ $gestion->descripcion_gestion }}
                    </li>
                @endforeach
            </ul>
        @else
            <p class="text-muted">No hay acciones registradas aún.</p>
        @endif
        @if($solicitud->estado !== 'cerrada')
        <form action="{{ route('admin.solicitudes.gestion.store', $solicitud->id) }}" method="POST" class="mb-3">
            @csrf
            <div class="form-group">
                <label for="descripcion">Nueva acción/gestión</label>
                <textarea name="descripcion" id="descripcion" class="form-control" rows="2" required></textarea>
            </div>
            <button type="submit" class="btn btn-success mt-2">Agregar acción</button>
        </form>
        
        <!-- Formulario de cierre mejorado -->
        <div class="card mt-4">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0">
                    <i class="fas fa-times-circle"></i> Cerrar Solicitud
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.solicitudes.cerrar', $solicitud->id) }}" method="POST" id="formCerrar">
                    @csrf
                    <div class="form-group mb-3">
                        <label for="observaciones_cierre" class="form-label">
                            <i class="fas fa-comment"></i> Observaciones de Cierre (Opcional)
                        </label>
                        <textarea 
                            name="observaciones_cierre" 
                            id="observaciones_cierre" 
                            class="form-control" 
                            rows="4" 
                            placeholder="Escriba aquí las observaciones finales, resolución del caso, o cualquier información relevante para el solicitante..."
                        ></textarea>
                        <small class="form-text text-muted">
                            Estas observaciones serán incluidas en el correo de notificación al solicitante.
                        </small>
                    </div>
                    
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Importante:</strong> Al cerrar esta solicitud se enviará automáticamente un correo de notificación al solicitante ({{ $solicitud->email ?? 'Sin email' }}).
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-danger" onclick="return confirmarCierre()">
                            <i class="fas fa-times-circle"></i> Cerrar Solicitud
                        </button>
                        <button type="button" class="btn btn-secondary" onclick="cancelarCierre()">
                            <i class="fas fa-ban"></i> Cancelar
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <script>
        function confirmarCierre() {
            const observaciones = document.getElementById('observaciones_cierre').value;
            let mensaje = '¿Está seguro de que desea cerrar esta solicitud?';
            
            if (observaciones.trim() === '') {
                mensaje += '\n\nNota: No ha ingresado observaciones de cierre.';
            }
            
            mensaje += '\n\nSe enviará una notificación por correo al solicitante.';
            
            return confirm(mensaje);
        }
        
        function cancelarCierre() {
            document.getElementById('observaciones_cierre').value = '';
        }
        </script>
        
        @endif
        <a href="{{ route('admin.solicitudes.index') }}" class="btn btn-secondary mt-3">Volver al listado</a>
    </div>
</div>
@endsection
