@extends('layouts.admin')

@section('title', 'Tipo de Solicitudes')

@push('styles')
    @vite(['resources/css/admin.css'])
@endpush

@section('content')
    <div class="admin-header">
        <h2 class="page-title">Listado de Tipos de Solicitudes</h2>
        <div class="d-flex justify-content-end">
            <a href="{{ route('admin.tipo-solicitudes.create') }}" class="btn btn-primary">
                Nuevo
                <i class="fas fa-plus me-1"></i> 
            </a>
        </div>
    </div>

    <div class="admin-responsive-table table-scroll-indicator">
        <table class="table table-hover mb-0">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th class="expandable-cell">Descripción</th>
                    <th>Estado</th>
                    <th class="text-center actions-cell" style="width: 150px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                @forelse($tipos as $tipo)
                    <tr>
                        <td>{{ $tipo->id }}</td>
                        <td>{{ $tipo->denominacion }}</td>
                        <td>{{ Str::limit($tipo->descripcion, 50) }}</td>
                        <td>
                            <span class="status-badge {{ $tipo->activo ? 'status-active' : 'status-inactive' }}">
                                {{ $tipo->activo ? 'Activo' : 'Inactivo' }}
                            </span>
                        </td>
                        <td class="text-center">
                            <div class="btn-actions">
                                <button type="button" class="btn btn-sm btn-outline-info" onclick="loadViewModal({{ $tipo->id }})" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-warning" onclick="loadEditModal({{ $tipo->id }})" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <form action="{{ route('admin.tipo-solicitudes.destroy', $tipo->id) }}" method="POST" class="d-inline delete-tipo-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Eliminar">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="empty-state">
                            <i class="fas fa-inbox fa-2x mb-2 text-muted"></i>
                            <p class="mb-0">No hay tipos de solicitudes registrados.</p>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @include('components.dynamic-modal')
@endsection

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Variables globales para JS
        window.successMessage = @json(session('success'));
        window.errorMessage = @json(session('error'));
        window.errorMessages = @json($errors->any() ? implode('<br>', $errors->all()) : null);
        window.tipoSolicitudesIndexRoute = "{{ route('admin.tipo-solicitudes.index') }}";
    </script>
    @vite(['resources/js/admin-tipos.js'])
@endpush
