@extends('layouts.auth')

@section('content')
<div class="auth-card">
    <div class="auth-logo">
        <img src="{{ asset('images/logo.png') }}" alt="Logo SIAC">
        <div class="auth-title">Iniciar Sesión</div>
        <div class="auth-subtitle">Sistema Integral de Atención Ciudadana</div>
    </div>

    @if(session('success'))
        <div class="auth-alert auth-alert-success">{{ session('success') }}</div>
    @endif

    @if($errors->any())
        <div class="auth-alert auth-alert-error">
            <ul style="margin: 0; padding-left: 1.2rem;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('login') }}" class="auth-form">
        @csrf
        
        <div class="auth-form-group">
            <label for="email" class="auth-form-label">Email</label>
            <input 
                type="email" 
                class="auth-form-input @error('email') is-invalid @enderror" 
                id="email" 
                name="email" 
                value="{{ old('email') }}" 
                required 
                autofocus
                placeholder="Ingrese su email"
            >
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="auth-form-group">
            <label for="password" class="auth-form-label">Contraseña</label>
            <input 
                type="password" 
                class="auth-form-input @error('password') is-invalid @enderror" 
                id="password" 
                name="password" 
                required
                placeholder="Ingrese su contraseña"
            >
            @error('password')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="auth-form-checkbox">
            <input type="checkbox" id="remember" name="remember" {{ old('remember') ? 'checked' : '' }}>
            <label for="remember">Recordarme</label>
        </div>

        <button type="submit" class="auth-btn">Ingresar</button>
    </form>

    <div class="auth-links">
        <small style="color: #6c757d; display: block; margin-top: 1.5rem; text-align: center;">
            SIAC &copy; {{ date('Y') }} - Municipalidad de Loncoche
        </small>
    </div>
</div>
@endsection
