<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitud Cerrada - SIAC</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 1rem;
        }

        .container {
            max-width: 600px;
            width: 100%;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        .header {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            padding: clamp(1.5rem, 4vw, 2rem);
            text-align: center;
        }

        .header h1 {
            font-size: clamp(1.25rem, 4vw, 1.5rem);
            margin-bottom: 0.5rem;
            font-weight: 600;
        }

        .header .subtitle {
            font-size: clamp(0.875rem, 3vw, 1rem);
            opacity: 0.9;
        }

        .content {
            padding: clamp(1.5rem, 4vw, 2.5rem);
        }

        .greeting {
            font-size: clamp(1rem, 3.5vw, 1.125rem);
            margin-bottom: 1.25rem;
            color: #2c3e50;
            font-weight: 500;
        }

        .message {
            background-color: #e8f5e8;
            border-left: 4px solid #28a745;
            padding: clamp(1rem, 3vw, 1.25rem);
            margin: clamp(1.25rem, 3vw, 1.5rem) 0;
            border-radius: 4px;
        }

        .message .icon {
            font-size: clamp(1.25rem, 4vw, 1.5rem);
            margin-bottom: 0.5rem;
            color: #28a745;
        }

        .message p {
            margin: 0;
            font-size: clamp(0.875rem, 3vw, 1rem);
            line-height: 1.5;
        }

        .details {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: clamp(1.25rem, 4vw, 1.5rem);
            margin: clamp(1.25rem, 3vw, 1.5rem) 0;
        }

        .details h3 {
            color: #495057;
            margin-bottom: 1rem;
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 0.5rem;
            font-size: clamp(1rem, 3.5vw, 1.125rem);
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            padding: 0.75rem 0;
            border-bottom: 1px solid #e9ecef;
            gap: 1rem;
        }

        .detail-row:last-child {
            border-bottom: none;
        }

        .detail-label {
            font-weight: 600;
            color: #6c757d;
            flex: 1;
            font-size: clamp(0.8rem, 3vw, 0.875rem);
            min-width: 0;
        }

        .detail-value {
            flex: 1.5;
            text-align: right;
            color: #495057;
            font-size: clamp(0.8rem, 3vw, 0.875rem);
            word-wrap: break-word;
            min-width: 0;
        }

        .status-badge {
            background-color: #28a745;
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 15px;
            font-size: clamp(0.7rem, 2.5vw, 0.75rem);
            font-weight: 600;
            text-transform: uppercase;
            white-space: nowrap;
        }

        .footer {
            background-color: #2c3e50;
            color: #ecf0f1;
            padding: clamp(1.5rem, 4vw, 2rem);
            text-align: center;
        }

        .footer p {
            margin-bottom: 0.75rem;
            font-size: clamp(0.875rem, 3vw, 1rem);
        }

        .footer .contact {
            font-size: clamp(0.8rem, 3vw, 0.875rem);
            opacity: 0.8;
            line-height: 1.4;
        }

        .btn {
            display: inline-block;
            padding: clamp(0.75rem, 3vw, 1rem) clamp(1.25rem, 4vw, 1.5rem);
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            margin: clamp(1rem, 3vw, 1.25rem) 0;
            transition: all 0.3s ease;
            font-size: clamp(0.875rem, 3vw, 1rem);
            text-align: center;
            max-width: 100%;
            box-sizing: border-box;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 123, 255, 0.3);
        }

        .alert-warning {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: clamp(1rem, 3vw, 1.25rem);
            margin: clamp(1.25rem, 3vw, 1.5rem) 0;
        }

        .alert-warning p {
            margin: 0;
            color: #856404;
            font-size: clamp(0.875rem, 3vw, 1rem);
            line-height: 1.5;
        }

        /* Texto normal del contenido */
        .content > p {
            font-size: clamp(0.875rem, 3vw, 1rem);
            line-height: 1.6;
            margin-bottom: 1rem;
        }

        @media (max-width: 768px) {
            body {
                padding: 0.5rem;
            }

            .container {
                margin: 0;
                border-radius: 4px;
                width: 100%;
                max-width: 100%;
            }

            .content,
            .header,
            .footer {
                padding: clamp(1rem, 3vw, 1.5rem);
            }

            .detail-row {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
                padding: 1rem 0;
            }

            .detail-value {
                text-align: left;
                margin-top: 0;
                width: 100%;
            }

            .status-badge {
                align-self: flex-start;
            }

            .btn {
                width: 100%;
                display: block;
                text-align: center;
                padding: 1rem;
            }

            .footer .contact {
                word-break: break-word;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 0.25rem;
            }

            .container {
                border-radius: 0;
            }

            .detail-row {
                padding: 0.75rem 0;
            }

            .header h1,
            .greeting,
            .details h3 {
                word-wrap: break-word;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>✅ Solicitud Completada</h1>
            <p class="subtitle">Sistema Integrado de Atención Ciudadana</p>
        </div>

        <!-- Content -->
        <div class="content">
            <div class="greeting">
                Estimado/a {{ $solicitante_nombre }},
            </div>

            <div class="message">
                <div class="icon">🎉</div>
                <p><strong>¡Excelentes noticias!</strong> Su solicitud ha sido procesada y cerrada exitosamente por
                    nuestro equipo.</p>
            </div>

            <p>Le informamos que su solicitud registrada en nuestro sistema ha sido completada satisfactoriamente. A
                continuación, encontrará los detalles de su solicitud:</p>

            <!-- Detalles de la solicitud -->
            <div class="details">
                <h3>📋 Detalles de la Solicitud</h3>

                <div class="detail-row">
                    <span class="detail-label">Número de Solicitud:</span>
                    <span class="detail-value"><strong>#{{ $solicitud->id }}</strong></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Tipo de Solicitud:</span>
                    <span class="detail-value">{{ $tipo_solicitud }}</span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Organismo:</span>
                    <span class="detail-value">{{ $organismo }}</span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Estado:</span>
                    <span class="detail-value">
                        <span class="status-badge">Cerrada</span>
                    </span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Fecha de Creación:</span>
                    <span class="detail-value">{{ $solicitud->created_at->format('d/m/Y H:i') }}</span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Fecha de Cierre:</span>
                    <span class="detail-value">{{ \Carbon\Carbon::parse($fecha_cierre)->format('d/m/Y H:i') }}</span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Tiempo de Resolución:</span>
                    <span class="detail-value"><strong>{{ $tiempo_resolucion }}</strong></span>
                </div>

                @if($gestor)
                    <div class="detail-row">
                        <span class="detail-label">Gestor Asignado:</span>
                        <span class="detail-value">{{ $gestor->name }}</span>
                    </div>
                @endif
            </div>

            @if($solicitud->observaciones_cierre)
                <div class="details">
                    <h3>📝 Observaciones del Cierre</h3>
                    <p style="margin-top: 15px; line-height: 1.6;">{{ $solicitud->observaciones_cierre }}</p>
                </div>
            @endif

            <p>Si tiene alguna consulta adicional o necesita más información sobre esta solicitud, no dude en
                contactarnos.</p>

            <div style="text-align: center; margin: clamp(1.5rem, 4vw, 2rem) 0;">
                <a href="#" class="btn">Ver Detalles en el Sistema</a>
            </div>

            <div class="alert-warning">
                <p><strong>💡 Importante:</strong> Este correo es generado
                    automáticamente. Si necesita realizar una nueva solicitud, puede acceder a nuestro sistema o
                    contactar directamente con el organismo correspondiente.</p>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p><strong>Sistema Integrado de Atención Ciudadana (SIAC)</strong></p>
            <p><strong>Municipalidad de Loncoche</strong></p>
            <p class="contact">
                📧 siac@muniloncochedigital.cl | 📞 +56452406565<br>
                🌐 https://municipalidaddeloncoche.cl/
            </p>
            <p style="font-size: clamp(0.7rem, 2.5vw, 0.75rem); opacity: 0.7; margin-top: 1.25rem; line-height: 1.4;">
                © {{ date('Y') }} SIAC. Todos los derechos reservados.<br>
                Este mensaje fue enviado a {{ $solicitud->email }}
            </p>
        </div>
    </div>
</body>

</html>