<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Página no encontrada - Panel Admin | SIAC</title>
    <meta name="description" content="La página solicitada en el panel de administración no fue encontrada.">
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Assets -->
    @vite(['resources/css/admin-404.css', 'resources/js/admin-404.js'])
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
</head>
<body>
    <div class="admin-404-container">
        <!-- Partículas flotantes -->
        <div class="admin-404-particles">
            <div class="particle"></div>
            <div class="particle"></div>
            <div class="particle"></div>
            <div class="particle"></div>
            <div class="particle"></div>
            <div class="particle"></div>
            <div class="particle"></div>
        </div>
        
        <!-- Contenido principal -->
        <div class="admin-404-content">
            <!-- Animación del número 404 -->
            <div class="admin-404-animation">
                <div class="admin-404-number">404</div>
                <div class="admin-404-icon">
                    <i class="fas fa-cog"></i>
                </div>
            </div>
            
            <!-- Títulos -->
            <h1 class="admin-404-title">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Página no encontrada
            </h1>
            
            <h2 class="admin-404-subtitle">
                Panel de Administración - SIAC
            </h2>
            
            <!-- Descripción -->
            <p class="admin-404-description">
                Lo sentimos, la página que buscas en el panel de administración no existe o ha sido movida.<br>
                Puede que hayas ingresado una URL incorrecta o que el recurso ya no esté disponible.
            </p>
            
            <!-- Acciones -->
            <div class="admin-404-actions">
                <a href="{{ route('admin.dashboard') }}" class="admin-404-btn admin-404-btn-primary">
                    <i class="fas fa-home"></i>
                    Ir al Dashboard
                </a>
                
                <button onclick="window.history.back()" class="admin-404-btn admin-404-btn-secondary">
                    <i class="fas fa-arrow-left"></i>
                    Volver atrás
                </button>
                
                <a href="{{ route('admin.solicitudes.index') }}" class="admin-404-btn">
                    <i class="fas fa-list"></i>
                    Ver Solicitudes
                </a>
            </div>
            
            <!-- Información adicional -->
            <div class="mt-4 text-center" style="opacity: 0.7; font-size: 0.85rem;">
                <p class="mb-2">
                    <i class="fas fa-keyboard me-1"></i>
                    <strong>Atajos de teclado:</strong>
                </p>
                <div class="d-flex justify-content-center gap-3 flex-wrap">
                    <span><kbd>H</kbd> Dashboard</span>
                    <span><kbd>B</kbd> Volver</span>
                    <span><kbd>R</kbd> Recargar</span>
                    <span><kbd>Esc</kbd> Salir</span>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Variables globales para JavaScript -->
    <script>
        window.adminRoutes = {
            dashboard: '{{ route("admin.dashboard") }}',
            solicitudes: '{{ route("admin.solicitudes.index") }}',
            home: '{{ url("/") }}'
        };
    </script>
</body>
</html>
