{{-- filepath: resources/views/layouts/app.blade.php --}}
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'Sistema de Solicitudes')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Google Fonts: Inter -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome para iconos -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="/css/root.css">
    <link rel="stylesheet" href="/css/app.css">
    @stack('styles')
</head>

<body>
    <div>
        @yield('content')
        
        {{-- Toasts globales --}}
        @php
            $toastScripts = [];
            if(session('success')) {
                $toastScripts[] = "showToast({text: " . json_encode(session('success')) . ", icon: 'success', timer: 4000});";
            }
            if(session('error')) {
                $toastScripts[] = "showToast({text: " . json_encode(session('error')) . ", icon: 'error', timer: 5000});";
            }
            // No procesar automáticamente $errors aquí, dejar que las vistas los manejen
        @endphp
        @if(count($toastScripts))
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    {!! implode("\n                    ", $toastScripts) !!}
                });
            </script>
        @endif
    </div>
    @yield('mirror-card')
    
    <!-- SweetAlert2 (para toast) -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="/js/toast-handler.js"></script>
    @stack('scripts')
</body>

</html>