@extends('layouts.app')
@section('title', 'Datos Estadísticos')

@section('content')
<div class="siac-app-card siac-view-statistics" style="margin-bottom: 6rem;">
  <!-- Formulario -->
  <form class="siac-form" action="{{ route('solicitudes.storeStatistics') }}" method="POST">
    @csrf
    <div class="siac-form-label-title" style="margin-bottom:1.5rem;">Datos Estadísticos (Opcional)</div>
    
    <label class="siac-form-label" for="tipo_zona">Tipo de Zona</label>
    <select name="tipo_zona" id="tipo_zona" class="siac-form-select">
      <option value="">Sin Información</option>
      <option value="Urbana" {{ old('tipo_zona') == 'Urbana' ? 'selected' : '' }}>Urbana</option>
      <option value="Rural" {{ old('tipo_zona') == 'Rural' ? 'selected' : '' }}>Rural</option>
    </select>

    <label class="siac-form-label" for="educacion">Educación</label>
    <select name="educacion" id="educacion" class="siac-form-select">
      <option value="">Sin Información</option>
      <option value="Básica" {{ old('educacion') == 'Básica' ? 'selected' : '' }}>Básica</option>
      <option value="Media" {{ old('educacion') == 'Media' ? 'selected' : '' }}>Media</option>
      <option value="Técnica" {{ old('educacion') == 'Técnica' ? 'selected' : '' }}>Técnica</option>
      <option value="Universitaria" {{ old('educacion') == 'Universitaria' ? 'selected' : '' }}>Universitaria</option>
      <option value="Postgrado" {{ old('educacion') == 'Postgrado' ? 'selected' : '' }}>Postgrado</option>
    </select>

    <label class="siac-form-label" for="usuario_respuesta">Medio de Respuesta</label>
    <select name="usuario_respuesta" id="usuario_respuesta" class="siac-form-select">
      <option value="">Seleccione una opción</option>
      <option value="Carta Certificada" {{ old('usuario_respuesta') == 'Carta Certificada' ? 'selected' : '' }}>Carta Certificada</option>
      <option value="Email" {{ old('usuario_respuesta') == 'Email' ? 'selected' : '' }}>Email</option>
      <option value="Retiro en oficina" {{ old('usuario_respuesta') == 'Retiro en oficina' ? 'selected' : '' }}>Retiro en oficina</option>
    </select>

    <label class="siac-form-label" for="edad">Edad</label>
    <select name="edad" id="edad" class="siac-form-select">
      <option value="">Sin Información</option>
      @for ($i = 18; $i <= 100; $i++)
        <option value="{{ $i }}" {{ old('edad') == $i ? 'selected' : '' }}>{{ $i }}</option>
      @endfor
    </select>

    <label class="siac-form-label" for="ocupacion">Ocupación</label>
    <select name="ocupacion" id="ocupacion" class="siac-form-select">
      <option value="">Sin Información</option>
      <option value="Estudiante" {{ old('ocupacion') == 'Estudiante' ? 'selected' : '' }}>Estudiante</option>
      <option value="Trabajador Dependiente" {{ old('ocupacion') == 'Trabajador Dependiente' ? 'selected' : '' }}>Trabajador Dependiente</option>
      <option value="Trabajador Independiente" {{ old('ocupacion') == 'Trabajador Independiente' ? 'selected' : '' }}>Trabajador Independiente</option>
      <option value="Empresario" {{ old('ocupacion') == 'Empresario' ? 'selected' : '' }}>Empresario</option>
      <option value="Jubilado/Pensionado" {{ old('ocupacion') == 'Jubilado/Pensionado' ? 'selected' : '' }}>Jubilado/Pensionado</option>
      <option value="Desempleado" {{ old('ocupacion') == 'Desempleado' ? 'selected' : '' }}>Desempleado</option>
      <option value="Dueña de Casa" {{ old('ocupacion') == 'Dueña de Casa' ? 'selected' : '' }}>Dueña de Casa</option>
    </select>

    <label class="siac-form-label" for="genero">Género</label>
    <select name="genero" id="genero" class="siac-form-select">
      <option value="">Sin Información</option>
      <option value="Masculino" {{ old('genero') == 'Masculino' ? 'selected' : '' }}>Masculino</option>
      <option value="Femenino" {{ old('genero') == 'Femenino' ? 'selected' : '' }}>Femenino</option>
      <option value="Otro" {{ old('genero') == 'Otro' ? 'selected' : '' }}>Otro</option>
      <option value="Prefiero no decir" {{ old('genero') == 'Prefiero no decir' ? 'selected' : '' }}>Prefiero no decir</option>
    </select>

    <label class="siac-form-label" for="organizacion">Organización (Opcional)</label>
    <input type="text" name="organizacion" id="organizacion" class="siac-form-input" value="{{ old('organizacion') }}">

    <label class="siac-form-label" for="apoderado">Representa a (Opcional)</label>
    <input type="text" name="apoderado" id="apoderado" class="siac-form-input" value="{{ old('apoderado') }}">

    <button type="submit" class="siac-form-btn">Continuar</button>
  </form>

  <!-- Panel Institucional -->
  <div class="siac-info-panel">
    <img src="/images/logo.png" alt="Logo Municipalidad de Loncoche" class="logo-muni">
    <div class="siac-info-title">Municipalidad de Loncoche</div>
    <div class="siac-info-subtitle">Sistema de Información y Atención Ciudadana</div>
    <div class="siac-info-desc">
      Estos datos estadísticos son opcionales y nos ayudan a mejorar nuestros servicios y generar estadísticas para la gestión municipal. La información proporcionada será tratada de forma confidencial.
    </div>
    <img src="/images/logo-copihue.png" alt="Loncoche" class="siac-info-img">
  </div>
</div>
@endsection

@section('mirror-card')
<div class="siac-view-statistics">
  @include('components.mirror_card', ['mirrorStep' => 'statistics'])
</div>
@endsection
