
<div class="card border-0 shadow-sm mb-3 filters-panel">
    <div class="card-body py-3">
        <form method="GET" class="row g-3 align-items-end">
            <div class="col-md-6 col-lg-5">
                <label class="form-label text-muted font-weight-semibold mb-1">Ordenar solicitudes activas:</label>
                <select name="order" class="form-control form-control-sm" onchange="this.form.submit()">
                    <option value="recientes"<?php echo e(request('order','recientes')=='recientes' ? ' selected' : ''); ?>>Más recientes</option>
                    <option value="antiguas"<?php echo e(request('order')=='antiguas' ? ' selected' : ''); ?>>Más antiguas</option>
                </select>
            </div>
            <div class="col-md-6 col-lg-4">
                <label class="form-label text-muted font-weight-semibold mb-1">Filtrar por estado:</label>
                <select name="estado" class="form-control form-control-sm" onchange="this.form.submit()">
                    <option value="">Todos los estados</option>
                    <option value="pendiente"<?php echo e(request('estado')=='pendiente' ? ' selected' : ''); ?>>Pendiente</option>
                    <option value="en_gestion"<?php echo e(request('estado')=='en_gestion' ? ' selected' : ''); ?>>En gestión</option>
                    <option value="cerrada"<?php echo e(request('estado')=='cerrada' ? ' selected' : ''); ?>>Cerrada</option>
                </select>
            </div>
            <div class="col-md-12 col-lg-3">
                <div class="d-flex align-items-center justify-content-lg-end">
                    <small class="filter-summary">
                        <i class="fas fa-filter mr-1"></i>
                        Total: <strong><?php echo e($solicitudes->total()); ?></strong> solicitudes
                    </small>
                </div>
            </div>
        </form>
    </div>
</div>


<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>


<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <div class="d-flex flex-wrap align-items-center">
            <small class="text-muted mr-3"><strong>Estados:</strong></small>
            <span class="badge badge-purple badge-pill px-2 py-1 mr-2 mb-1">
                <i class="fas fa-clock mr-1"></i>Pendiente
            </span>
            <span class="badge badge-blue badge-pill px-2 py-1 mr-2 mb-1">
                <i class="fas fa-cogs mr-1"></i>En gestión
            </span>
            <span class="badge badge-green badge-pill px-2 py-1 mr-3 mb-1">
                <i class="fas fa-check-circle mr-1"></i>Cerrada
            </span>
            <small class="text-muted">Las solicitudes cerradas aparecen con fondo gris al final de la lista</small>
        </div>
    </div>
</div>
<?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/partials/filters.blade.php ENDPATH**/ ?>