
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Panel de Administración'); ?></title>
    <!-- Bootstrap CSS desde AdminLTE -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="<?php echo e(asset('vendor/adminlte/plugins/fontawesome-free/css/all.min.css')); ?>">
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('vendor/adminlte/css/adminlte.min.css')); ?>">
    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body class="hold-transition sidebar-mini">
    <div class="wrapper">
        <?php echo $__env->make('admin.partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="content-wrapper">
            <section class="content pt-3">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                    
                    <?php
                        $toastScripts = [];
                        if(session('success')) {
                            $toastScripts[] = "showToast({text: " . json_encode(session('success')) . ", icon: 'success', timer: 4000});";
                        }
                        foreach($errors->all() as $error) {
                            $toastScripts[] = "showToast({text: " . json_encode($error) . ", icon: 'error', timer: 5000});";
                        }
                    ?>
                    <?php if(count($toastScripts)): ?>
                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                <?php echo implode("\n                                ", $toastScripts); ?>

                            });
                        </script>
                    <?php endif; ?>
                </div>
            </section>
        </div>
        <footer class="main-footer">
            <div class="float-right d-none d-sm-block">
                <b>Versión</b> 1.0
            </div>
            <strong>SIAC &copy; <?php echo e(date('Y')); ?></strong>
        </footer>
    </div>
    <!-- jQuery, Bootstrap JS y AdminLTE JS (en orden correcto) -->
    <script src="<?php echo e(asset('vendor/adminlte/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/adminlte/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/adminlte/js/adminlte.min.js')); ?>"></script>
    <!-- SweetAlert2 (para toast) -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="/js/toast-handler.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html><?php /**PATH /var/www/html/siac/resources/views/layouts/admin.blade.php ENDPATH**/ ?>