
<?php
    $evidencias = [];
    if($solicitud->uri_evidencia && file_exists($solicitud->uri_evidencia)) {
        $evidenciaPath = $solicitud->uri_evidencia;
        if (is_dir($evidenciaPath)) {
            $scanFiles = scandir($evidenciaPath);
            foreach ($scanFiles as $file) {
                if ($file !== '.' && $file !== '..' && is_file($evidenciaPath . '/' . $file)) {
                    $filePath = $evidenciaPath . '/' . $file;
                    $evidencias[] = [
                        'name' => $file,
                        'size' => filesize($filePath),
                        'modified' => date('d/m/Y H:i', filemtime($filePath)),
                        'extension' => strtolower(pathinfo($file, PATHINFO_EXTENSION)),
                        'download_url' => route('admin.solicitudes.download-evidencia', ['id' => $solicitud->id, 'filename' => $file])
                    ];
                }
            }
        }
    }
?>

<div class="evidencias-section">
    <?php if(count($evidencias) > 0): ?>
        <div class="evidencias-header mb-3">
            <h6 class="mb-0">
                <i class="fas fa-paperclip me-2"></i>
                Evidencias adjuntas (<?php echo e(count($evidencias)); ?>)
            </h6>
            <?php if(count($evidencias) > 1): ?>
                <button type="button" 
                        class="btn btn-sm btn-outline-primary download-all-btn"
                        data-solicitud-id="<?php echo e($solicitud->id); ?>"
                        title="Descargar todas las evidencias">
                    <i class="fas fa-download me-1"></i>
                    Descargar todas
                </button>
            <?php endif; ?>
        </div>

        <div class="evidencias-list">
            <?php $__currentLoopData = $evidencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evidencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="evidencia-item">
                    <div class="evidencia-content">
                        <div class="evidencia-icon">
                            <?php if(in_array($evidencia['extension'], ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'])): ?>
                                <i class="fas fa-image text-success"></i>
                            <?php elseif($evidencia['extension'] === 'pdf'): ?>
                                <i class="fas fa-file-pdf text-danger"></i>
                            <?php elseif(in_array($evidencia['extension'], ['doc', 'docx'])): ?>
                                <i class="fas fa-file-word text-primary"></i>
                            <?php elseif(in_array($evidencia['extension'], ['xls', 'xlsx'])): ?>
                                <i class="fas fa-file-excel text-success"></i>
                            <?php elseif($evidencia['extension'] === 'txt'): ?>
                                <i class="fas fa-file-alt text-muted"></i>
                            <?php elseif(in_array($evidencia['extension'], ['zip', 'rar', '7z'])): ?>
                                <i class="fas fa-file-archive text-warning"></i>
                            <?php else: ?>
                                <i class="fas fa-file text-muted"></i>
                            <?php endif; ?>
                        </div>

                        <div class="evidencia-info">
                            <div class="evidencia-name" title="<?php echo e($evidencia['name']); ?>">
                                <?php echo e(Str::limit($evidencia['name'], 35)); ?>

                            </div>
                            <div class="evidencia-meta">
                                <span class="file-size"><?php echo e(number_format($evidencia['size'] / 1024, 1)); ?> KB</span>
                                <span class="file-date"><?php echo e($evidencia['modified']); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="evidencia-actions">
                        <a href="<?php echo e($evidencia['download_url']); ?>" 
                           class="btn btn-sm btn-outline-primary download-btn"
                           title="Descargar <?php echo e($evidencia['name']); ?>">
                            <i class="fas fa-download"></i>
                        </a>

                        <?php if(in_array($evidencia['extension'], ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'])): ?>
                            <button type="button" 
                                    class="btn btn-sm btn-outline-info preview-btn"
                                    data-image-url="<?php echo e($evidencia['download_url']); ?>"
                                    data-image-name="<?php echo e($evidencia['name']); ?>"
                                    title="Vista previa de <?php echo e($evidencia['name']); ?>">
                                <i class="fas fa-eye"></i>
                            </button>
                        <?php endif; ?>

                        <button type="button" 
                                class="btn btn-sm btn-outline-secondary copy-link-btn"
                                data-url="<?php echo e($evidencia['download_url']); ?>"
                                title="Copiar enlace de descarga">
                            <i class="fas fa-link"></i>
                        </button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="evidencias-empty">
            <div class="empty-icon">
                <i class="fas fa-folder-open"></i>
            </div>
            <h6 class="empty-title">Sin evidencias adjuntas</h6>
            <p class="empty-text">No se han adjuntado evidencias a esta solicitud.</p>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/partials/evidencias.blade.php ENDPATH**/ ?>